/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.guava;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class ComparatorsTest {
    @Test
    public void testInverse() throws Exception {
        Comparator normal = Comparators.comparable();
        Comparator inverted = Comparators.inverse((Comparator)normal);
        Assert.assertEquals((long)-1L, (long)normal.compare(0, 1));
        Assert.assertEquals((long)1L, (long)normal.compare(1, 0));
        Assert.assertEquals((long)0L, (long)normal.compare(1, 1));
        Assert.assertEquals((long)1L, (long)inverted.compare(0, 1));
        Assert.assertEquals((long)-1L, (long)inverted.compare(1, 0));
        Assert.assertEquals((long)0L, (long)inverted.compare(1, 1));
    }

    @Test
    public void testInverseOverflow() {
        Comparator invertedSimpleIntegerComparator = Comparators.inverse((Comparator)new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1 - o2;
            }
        });
        Assert.assertTrue((invertedSimpleIntegerComparator.compare(0, Integer.MIN_VALUE) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntervalsByStartThenEnd() throws Exception {
        Comparator comp = Comparators.intervalsByStartThenEnd();
        Assert.assertEquals((long)0L, (long)comp.compare(Intervals.of((String)"P1d/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-02")));
        Assert.assertEquals((long)-1L, (long)comp.compare(Intervals.of((String)"2011-03-31/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-02")));
        Assert.assertEquals((long)1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-03-31/2011-04-02")));
        Assert.assertEquals((long)1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-02")));
        Assert.assertEquals((long)-1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04")));
        Object[] intervals = new Interval[]{Intervals.of((String)"2011-04-01T18/2011-04-02T13"), Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04"), Intervals.of((String)"2011-04-02/2011-04-04"), Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-02/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03T06")};
        Arrays.sort(intervals, comp);
        Assert.assertArrayEquals((Object[])new Interval[]{Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04"), Intervals.of((String)"2011-04-01T18/2011-04-02T13"), Intervals.of((String)"2011-04-02/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03T06"), Intervals.of((String)"2011-04-02/2011-04-04")}, (Object[])intervals);
    }

    @Test
    public void testIntervalsByEndThenStart() throws Exception {
        Comparator comp = Comparators.intervalsByEndThenStart();
        Assert.assertEquals((long)0L, (long)comp.compare(Intervals.of((String)"P1d/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-02")));
        Assert.assertEquals((long)-1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04")));
        Assert.assertEquals((long)1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-01")));
        Assert.assertEquals((long)-1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03")));
        Assert.assertEquals((long)1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-03-31/2011-04-03")));
        Object[] intervals = new Interval[]{Intervals.of((String)"2011-04-01T18/2011-04-02T13"), Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04"), Intervals.of((String)"2011-04-02/2011-04-04"), Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-02/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03T06")};
        Arrays.sort(intervals, comp);
        Assert.assertArrayEquals((Object[])new Interval[]{Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-01T18/2011-04-02T13"), Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03T06"), Intervals.of((String)"2011-04-01/2011-04-04"), Intervals.of((String)"2011-04-02/2011-04-04")}, (Object[])intervals);
    }
}

