/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.curator;

import org.apache.curator.framework.CuratorFramework;
import org.apache.hive.druid.io.druid.curator.CuratorTestBase;
import org.apache.hive.druid.io.druid.curator.CuratorUtils;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.zookeeper.CreateMode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CuratorUtilsTest
extends CuratorTestBase {
    @Before
    public void setUp() throws Exception {
        this.setupServerAndCurator();
    }

    @After
    public void tearDown() {
        this.tearDownServerAndCurator();
    }

    @Test(timeout=10000L)
    public void testCreateIfNotExists() throws Exception {
        this.curator.start();
        this.curator.blockUntilConnected();
        CuratorUtils.createIfNotExists((CuratorFramework)this.curator, (String)"/foo/bar", (CreateMode)CreateMode.PERSISTENT, (byte[])StringUtils.toUtf8((String)"baz"), (int)524288);
        Assert.assertEquals((Object)"baz", (Object)StringUtils.fromUtf8((byte[])((byte[])this.curator.getData().forPath("/foo/bar"))));
        CuratorUtils.createIfNotExists((CuratorFramework)this.curator, (String)"/foo/bar", (CreateMode)CreateMode.PERSISTENT, (byte[])StringUtils.toUtf8((String)"qux"), (int)524288);
        Assert.assertEquals((Object)"baz", (Object)StringUtils.fromUtf8((byte[])((byte[])this.curator.getData().forPath("/foo/bar"))));
    }

    @Test(timeout=10000L)
    public void testCreateIfNotExistsPayloadTooLarge() throws Exception {
        this.curator.start();
        this.curator.blockUntilConnected();
        Exception thrown = null;
        try {
            CuratorUtils.createIfNotExists((CuratorFramework)this.curator, (String)"/foo/bar", (CreateMode)CreateMode.PERSISTENT, (byte[])StringUtils.toUtf8((String)"baz"), (int)2);
        }
        catch (Exception e) {
            thrown = e;
        }
        Assert.assertTrue((boolean)(thrown instanceof IllegalArgumentException));
        Assert.assertNull((Object)this.curator.checkExists().forPath("/foo/bar"));
    }

    @Test(timeout=10000L)
    public void testCreateOrSet() throws Exception {
        this.curator.start();
        this.curator.blockUntilConnected();
        Assert.assertNull((Object)this.curator.checkExists().forPath("/foo/bar"));
        CuratorUtils.createOrSet((CuratorFramework)this.curator, (String)"/foo/bar", (CreateMode)CreateMode.PERSISTENT, (byte[])StringUtils.toUtf8((String)"baz"), (int)3);
        Assert.assertEquals((Object)"baz", (Object)StringUtils.fromUtf8((byte[])((byte[])this.curator.getData().forPath("/foo/bar"))));
        CuratorUtils.createOrSet((CuratorFramework)this.curator, (String)"/foo/bar", (CreateMode)CreateMode.PERSISTENT, (byte[])StringUtils.toUtf8((String)"qux"), (int)3);
        Assert.assertEquals((Object)"qux", (Object)StringUtils.fromUtf8((byte[])((byte[])this.curator.getData().forPath("/foo/bar"))));
    }

    @Test(timeout=10000L)
    public void testCreateOrSetPayloadTooLarge() throws Exception {
        this.curator.start();
        this.curator.blockUntilConnected();
        Exception thrown = null;
        try {
            CuratorUtils.createOrSet((CuratorFramework)this.curator, (String)"/foo/bar", (CreateMode)CreateMode.PERSISTENT, (byte[])StringUtils.toUtf8((String)"baz"), (int)2);
        }
        catch (Exception e) {
            thrown = e;
        }
        Assert.assertTrue((boolean)(thrown instanceof IllegalArgumentException));
        Assert.assertNull((Object)this.curator.checkExists().forPath("/foo/bar"));
    }
}

