/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.indexing;

import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.client.indexing.ClientMergeQuery;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class ClientMergeQueryTest {
    private static final String DATA_SOURCE = "data_source";
    public static final DateTime START = DateTimes.nowUtc();
    private static final Interval INTERVAL = new Interval((ReadableInstant)START, (ReadableInstant)START.plus(1L));
    private static final DataSegment DATA_SEGMENT = new DataSegment("data_source", INTERVAL, START.toString(), null, null, null, null, Integer.valueOf(0), 0L);
    private static final List<DataSegment> SEGMENT_LIST = Lists.newArrayList((Object[])new DataSegment[]{DATA_SEGMENT});
    private static final List<AggregatorFactory> AGGREGATOR_LIST = Lists.newArrayList();
    private static final ClientMergeQuery CLIENT_MERGE_QUERY = new ClientMergeQuery("data_source", SEGMENT_LIST, AGGREGATOR_LIST);

    @Test
    public void testGetType() {
        Assert.assertEquals((Object)"merge", (Object)CLIENT_MERGE_QUERY.getType());
    }

    @Test
    public void testGetDataSource() {
        Assert.assertEquals((Object)DATA_SOURCE, (Object)CLIENT_MERGE_QUERY.getDataSource());
    }

    @Test
    public void testGetSegments() {
        Assert.assertEquals(SEGMENT_LIST, (Object)CLIENT_MERGE_QUERY.getSegments());
    }

    @Test
    public void testGetAggregators() {
        Assert.assertEquals(AGGREGATOR_LIST, (Object)CLIENT_MERGE_QUERY.getAggregators());
    }

    @Test
    public void testToString() {
        Assert.assertTrue((boolean)CLIENT_MERGE_QUERY.toString().contains(DATA_SOURCE));
        Assert.assertTrue((boolean)CLIENT_MERGE_QUERY.toString().contains(SEGMENT_LIST.toString()));
        Assert.assertTrue((boolean)CLIENT_MERGE_QUERY.toString().contains(AGGREGATOR_LIST.toString()));
    }
}

