/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.metamx.common.RetryUtils;
import org.junit.Assert;
import org.junit.Test;

public class RetryUtilsTest {
    private static final Predicate<Throwable> isTransient = new Predicate<Throwable>(){

        public boolean apply(Throwable e) {
            return e instanceof IOException && e.getMessage().equals("what");
        }
    };

    @Test
    public void testImmediateSuccess() throws Exception {
        final AtomicInteger count = new AtomicInteger();
        String result = (String)RetryUtils.retry((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                count.incrementAndGet();
                return "hey";
            }
        }, isTransient, (int)2);
        Assert.assertEquals((String)"result", (Object)"hey", (Object)result);
        Assert.assertEquals((String)"count", (long)1L, (long)count.get());
    }

    @Test
    public void testEventualFailure() throws Exception {
        final AtomicInteger count = new AtomicInteger();
        boolean threwExpectedException = false;
        try {
            RetryUtils.retry((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    count.incrementAndGet();
                    throw new IOException("what");
                }
            }, isTransient, (int)2);
        }
        catch (IOException e) {
            threwExpectedException = e.getMessage().equals("what");
        }
        Assert.assertTrue((String)"threw expected exception", (boolean)threwExpectedException);
        Assert.assertEquals((String)"count", (long)2L, (long)count.get());
    }

    @Test
    public void testEventualSuccess() throws Exception {
        final AtomicInteger count = new AtomicInteger();
        String result = (String)RetryUtils.retry((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (count.incrementAndGet() >= 2) {
                    return "hey";
                }
                throw new IOException("what");
            }
        }, isTransient, (int)3);
        Assert.assertEquals((String)"result", (Object)"hey", (Object)result);
        Assert.assertEquals((String)"count", (long)2L, (long)count.get());
    }

    @Test
    public void testExceptionPredicateNotMatching() throws Exception {
        final AtomicInteger count = new AtomicInteger();
        boolean threwExpectedException = false;
        try {
            RetryUtils.retry((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    if (count.incrementAndGet() >= 2) {
                        return "hey";
                    }
                    throw new IOException("uhh");
                }
            }, isTransient, (int)3);
        }
        catch (IOException e) {
            threwExpectedException = e.getMessage().equals("uhh");
        }
        Assert.assertTrue((String)"threw expected exception", (boolean)threwExpectedException);
        Assert.assertEquals((String)"count", (long)1L, (long)count.get());
    }
}

