/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericObjectPoolClassLoaders {
    private static final URL BASE_URL = TestGenericObjectPoolClassLoaders.class.getResource("/org/apache/commons/pool2/impl/");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContextClassLoader() throws Exception {
        ClassLoader savedClassloader = Thread.currentThread().getContextClassLoader();
        try {
            int counter;
            CustomClassLoader cl1 = new CustomClassLoader(1);
            Thread.currentThread().setContextClassLoader(cl1);
            CustomClassLoaderObjectFactory factory1 = new CustomClassLoaderObjectFactory(1);
            GenericObjectPool pool1 = new GenericObjectPool((PooledObjectFactory)factory1);
            pool1.setMinIdle(1);
            pool1.setTimeBetweenEvictionRunsMillis(100L);
            for (counter = 0; counter < 50 && pool1.getNumIdle() != 1; ++counter) {
                Thread.sleep(100L);
            }
            Assert.assertEquals((String)"Wrong number of idle objects in pool1", (long)1L, (long)pool1.getNumIdle());
            CustomClassLoader cl2 = new CustomClassLoader(2);
            Thread.currentThread().setContextClassLoader(cl2);
            CustomClassLoaderObjectFactory factory2 = new CustomClassLoaderObjectFactory(2);
            GenericObjectPool pool2 = new GenericObjectPool((PooledObjectFactory)factory2);
            pool2.setMinIdle(1);
            pool2.addObject();
            Assert.assertEquals((String)"Wrong number of idle objects in pool2", (long)1L, (long)pool2.getNumIdle());
            pool2.clear();
            pool2.setTimeBetweenEvictionRunsMillis(100L);
            for (counter = 0; counter < 50 && pool2.getNumIdle() != 1; ++counter) {
                Thread.sleep(100L);
            }
            Assert.assertEquals((String)"Wrong number of  idle objects in pool2", (long)1L, (long)pool2.getNumIdle());
            pool1.close();
            pool2.close();
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedClassloader);
        }
    }

    private static class CustomClassLoader
    extends URLClassLoader {
        private int n;

        CustomClassLoader(int n) {
            super(new URL[]{BASE_URL});
            this.n = n;
        }

        @Override
        public URL findResource(String name) {
            if (!name.endsWith(String.valueOf(this.n))) {
                return null;
            }
            return super.findResource(name);
        }
    }

    private static class CustomClassLoaderObjectFactory
    extends BasePooledObjectFactory<URL> {
        private int n;

        CustomClassLoaderObjectFactory(int n) {
            this.n = n;
        }

        public URL create() throws Exception {
            URL url = Thread.currentThread().getContextClassLoader().getResource("test" + this.n);
            if (url == null) {
                throw new IllegalStateException("Object should not be null");
            }
            return url;
        }

        public PooledObject<URL> wrap(URL value) {
            return new DefaultPooledObject((Object)value);
        }
    }
}

