/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.commons.lang3.Functions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FunctionsTest {
    FunctionsTest() {
    }

    @Test
    void testRunnable() {
        FailureOnOddInvocations.invocation = 0;
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> Functions.run(FailureOnOddInvocations::new));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        Functions.run(FailureOnOddInvocations::new);
    }

    @Test
    void testCallable() {
        FailureOnOddInvocations.invocation = 0;
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> Functions.run(FailureOnOddInvocations::new));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        FailureOnOddInvocations instance = (FailureOnOddInvocations)Functions.call(FailureOnOddInvocations::new);
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    void testAcceptConsumer() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Functions.accept(Testable::test, (Object)testable));
        Assertions.assertSame((Object)ise, (Object)e);
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Functions.accept(Testable::test, (Object)testable));
        Assertions.assertSame((Object)error, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Functions.accept(Testable::test, (Object)testable));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Functions.accept(Testable::test, (Object)testable);
    }

    @Test
    void testAcceptBiConsumer() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(null);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Functions.accept(Testable::test, (Object)testable, (Object)ise));
        Assertions.assertSame((Object)ise, (Object)e);
        OutOfMemoryError error = new OutOfMemoryError();
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Functions.accept(Testable::test, (Object)testable, (Object)error));
        Assertions.assertSame((Object)error, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Functions.accept(Testable::test, (Object)testable, (Object)ioe));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Functions.accept(Testable::test, (Object)testable, (Object)null);
    }

    @Test
    public void testApplyFunction() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Functions.apply(Testable::testInt, (Object)testable));
        Assertions.assertSame((Object)ise, (Object)e);
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Functions.apply(Testable::testInt, (Object)testable));
        Assertions.assertSame((Object)error, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Functions.apply(Testable::testInt, (Object)testable));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Integer i = (Integer)Functions.apply(Testable::testInt, (Object)testable);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    public void testApplyBiFunction() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(null);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Functions.apply(Testable::testInt, (Object)testable, (Object)ise));
        Assertions.assertSame((Object)ise, (Object)e);
        OutOfMemoryError error = new OutOfMemoryError();
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Functions.apply(Testable::testInt, (Object)testable, (Object)error));
        Assertions.assertSame((Object)error, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Functions.apply(Testable::testInt, (Object)testable, (Object)ioe));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Integer i = (Integer)Functions.apply(Testable::testInt, (Object)testable, (Object)null);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    public void testTryWithResources() {
        CloseableObject co = new CloseableObject();
        Functions.FailableConsumer consumer = co::run;
        IllegalStateException ise = new IllegalStateException();
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> {
            Functions.FailableRunnable[] failableRunnableArray = new Functions.FailableRunnable[1];
            failableRunnableArray[0] = co::close;
            Functions.tryWithResources(() -> consumer.accept((Object)ise), (Functions.FailableRunnable[])failableRunnableArray);
        });
        Assertions.assertSame((Object)ise, (Object)e);
        Assertions.assertTrue((boolean)co.isClosed());
        co.reset();
        OutOfMemoryError error = new OutOfMemoryError();
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> {
            Functions.FailableRunnable[] failableRunnableArray = new Functions.FailableRunnable[1];
            failableRunnableArray[0] = co::close;
            Functions.tryWithResources(() -> consumer.accept((Object)error), (Functions.FailableRunnable[])failableRunnableArray);
        });
        Assertions.assertSame((Object)error, (Object)e);
        Assertions.assertTrue((boolean)co.isClosed());
        co.reset();
        IOException ioe = new IOException("Unknown I/O error");
        UncheckedIOException uioe = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> {
            Functions.FailableRunnable[] failableRunnableArray = new Functions.FailableRunnable[1];
            failableRunnableArray[0] = co::close;
            Functions.tryWithResources(() -> consumer.accept((Object)ioe), (Functions.FailableRunnable[])failableRunnableArray);
        });
        IOException cause = uioe.getCause();
        Assertions.assertSame((Object)ioe, (Object)cause);
        Assertions.assertTrue((boolean)co.isClosed());
        co.reset();
        Functions.FailableRunnable[] failableRunnableArray = new Functions.FailableRunnable[1];
        failableRunnableArray[0] = co::close;
        Functions.tryWithResources(() -> consumer.accept(null), (Functions.FailableRunnable[])failableRunnableArray);
        Assertions.assertTrue((boolean)co.isClosed());
    }

    public static class CloseableObject {
        private boolean closed;

        public void run(Throwable pTh) throws Throwable {
            if (pTh != null) {
                throw pTh;
            }
        }

        public void reset() {
            this.closed = false;
        }

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    public static class FailureOnOddInvocations {
        private static int invocation;

        FailureOnOddInvocations() throws SomeException {
            int i = ++invocation;
            if (i % 2 == 1) {
                throw new SomeException("Odd Invocation: " + i);
            }
        }
    }

    public static class Testable {
        private Throwable t;

        Testable(Throwable pTh) {
            this.t = pTh;
        }

        public void setThrowable(Throwable pThrowable) {
            this.t = pThrowable;
        }

        public void test() throws Throwable {
            this.test(this.t);
        }

        public void test(Throwable pThrowable) throws Throwable {
            if (pThrowable != null) {
                throw pThrowable;
            }
        }

        public Integer testInt() throws Throwable {
            return this.testInt(this.t);
        }

        public Integer testInt(Throwable pThrowable) throws Throwable {
            if (pThrowable != null) {
                throw pThrowable;
            }
            return 0;
        }
    }

    public static class SomeException
    extends Exception {
        private static final long serialVersionUID = -4965704778119283411L;
        private Throwable t;

        SomeException(String pMsg) {
            super(pMsg);
        }

        public void setThrowable(Throwable pThrowable) {
            this.t = pThrowable;
        }

        public void test() throws Throwable {
            if (this.t != null) {
                throw this.t;
            }
        }
    }
}

