/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import junit.framework.TestCase;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.CPDSConnectionFactory;
import org.apache.commons.dbcp2.datasources.ConnectionPoolDataSourceProxy;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSource;
import org.apache.commons.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp2.datasources.PooledConnectionProxy;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class TestCPDSConnectionFactory
extends TestCase {
    protected ConnectionPoolDataSourceProxy cpds = null;

    public TestCPDSConnectionFactory(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        this.cpds = new ConnectionPoolDataSourceProxy((ConnectionPoolDataSource)new DriverAdapterCPDS());
        DriverAdapterCPDS delegate = (DriverAdapterCPDS)this.cpds.getDelegate();
        delegate.setDriver("org.apache.commons.dbcp2.TesterDriver");
        delegate.setUrl("jdbc:apache:commons:testdriver");
        delegate.setUser("username");
        delegate.setPassword("password");
    }

    public void testSharedPoolDSDestroyOnReturn() throws Exception {
        PerUserPoolDataSource ds = new PerUserPoolDataSource();
        ds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.cpds);
        ds.setPerUserMaxTotal("username", Integer.valueOf(10));
        ds.setPerUserMaxWaitMillis("username", Long.valueOf(50L));
        ds.setPerUserMaxIdle("username", Integer.valueOf(2));
        Connection conn1 = ds.getConnection("username", "password");
        Connection conn2 = ds.getConnection("username", "password");
        Connection conn3 = ds.getConnection("username", "password");
        TestCPDSConnectionFactory.assertEquals((int)3, (int)ds.getNumActive("username"));
        conn1.close();
        TestCPDSConnectionFactory.assertEquals((int)1, (int)ds.getNumIdle("username"));
        conn2.close();
        TestCPDSConnectionFactory.assertEquals((int)2, (int)ds.getNumIdle("username"));
        conn3.close();
        TestCPDSConnectionFactory.assertEquals((int)2, (int)ds.getNumIdle("username"));
    }

    public void testConnectionErrorCleanup() throws Exception {
        CPDSConnectionFactory factory = new CPDSConnectionFactory((ConnectionPoolDataSource)this.cpds, null, -1, false, "username", "password");
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool((ObjectPool)pool);
        PooledConnection pcon1 = ((PooledConnectionAndInfo)pool.borrowObject()).getPooledConnection();
        Connection con1 = pcon1.getConnection();
        PooledConnection pcon2 = ((PooledConnectionAndInfo)pool.borrowObject()).getPooledConnection();
        TestCPDSConnectionFactory.assertEquals((int)2, (int)pool.getNumActive());
        TestCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumIdle());
        PooledConnectionProxy pc = (PooledConnectionProxy)pcon1;
        TestCPDSConnectionFactory.assertTrue((boolean)pc.getListeners().contains(factory));
        pc.throwConnectionError();
        TestCPDSConnectionFactory.assertEquals((int)1, (int)pool.getNumActive());
        TestCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumIdle());
        pc.throwConnectionError();
        TestCPDSConnectionFactory.assertEquals((int)1, (int)pool.getNumActive());
        TestCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumIdle());
        PooledConnection pcon3 = ((PooledConnectionAndInfo)pool.borrowObject()).getPooledConnection();
        TestCPDSConnectionFactory.assertTrue((!pcon3.equals(pcon1) ? 1 : 0) != 0);
        TestCPDSConnectionFactory.assertTrue((!pc.getListeners().contains(factory) ? 1 : 0) != 0);
        TestCPDSConnectionFactory.assertEquals((int)2, (int)pool.getNumActive());
        TestCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumIdle());
        pcon2.getConnection().close();
        pcon3.getConnection().close();
        TestCPDSConnectionFactory.assertEquals((int)2, (int)pool.getNumIdle());
        TestCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumActive());
        try {
            pc.getConnection();
            TestCPDSConnectionFactory.fail((String)"Expecting SQLException using closed PooledConnection");
        }
        catch (SQLException ex) {
            // empty catch block
        }
        con1.close();
        TestCPDSConnectionFactory.assertEquals((int)2, (int)pool.getNumIdle());
        TestCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumActive());
        factory.getPool().clear();
        TestCPDSConnectionFactory.assertEquals((int)0, (int)pool.getNumIdle());
    }
}

