/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import junit.framework.TestCase;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingPreparedStatement;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.dbcp2.TesterPreparedStatement;

public class TestDelegatingPreparedStatement
extends TestCase {
    private DelegatingConnection<Connection> conn = null;
    private Connection delegateConn = null;
    private DelegatingPreparedStatement stmt = null;
    private PreparedStatement delegateStmt = null;

    public TestDelegatingPreparedStatement(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        this.delegateConn = new TesterConnection("test", "test");
        this.conn = new DelegatingConnection(this.delegateConn);
    }

    public void testExecuteQueryReturnsNull() throws Exception {
        this.delegateStmt = new TesterPreparedStatement(this.delegateConn, "null");
        this.stmt = new DelegatingPreparedStatement(this.conn, this.delegateStmt);
        TestDelegatingPreparedStatement.assertNull((Object)this.stmt.executeQuery());
    }

    public void testExecuteQueryReturnsNotNull() throws Exception {
        this.delegateStmt = new TesterPreparedStatement(this.delegateConn, "select * from foo");
        this.stmt = new DelegatingPreparedStatement(this.conn, this.delegateStmt);
        TestDelegatingPreparedStatement.assertTrue((null != this.stmt.executeQuery() ? 1 : 0) != 0);
    }

    public void testGetDelegate() throws Exception {
        this.delegateStmt = new TesterPreparedStatement(this.delegateConn, "select * from foo");
        this.stmt = new DelegatingPreparedStatement(this.conn, this.delegateStmt);
        TestDelegatingPreparedStatement.assertEquals((Object)this.delegateStmt, (Object)this.stmt.getDelegate());
    }
}

