/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import junit.framework.TestCase;
import org.apache.commons.compress.harmony.pack200.Archive;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.pack200.PackingOptions;

public class PackingOptionsTest
extends TestCase {
    JarFile in;
    OutputStream out;
    File file;

    public void testKeepFileOrder() throws Exception {
        PackingOptions options = new PackingOptions();
        PackingOptionsTest.assertTrue((boolean)options.isKeepFileOrder());
        options.setKeepFileOrder(false);
        PackingOptionsTest.assertFalse((boolean)options.isKeepFileOrder());
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        this.file = File.createTempFile("sql", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        options = new PackingOptions();
        options.setGzip(false);
        Archive archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("sql", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        JarFile jarFile = new JarFile(file2);
        JarFile jarFile2 = new JarFile(compareFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        Enumeration<JarEntry> entries2 = jarFile2.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            PackingOptionsTest.assertNotNull((Object)entry);
            JarEntry entry2 = entries2.nextElement();
            String name = entry.getName();
            String name2 = entry2.getName();
            PackingOptionsTest.assertEquals((String)name, (String)name2);
        }
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        this.file = File.createTempFile("sql", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        options = new PackingOptions();
        options.setKeepFileOrder(false);
        options.setGzip(false);
        archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        in2 = new FileInputStream(this.file);
        file2 = File.createTempFile("sql", ".jar");
        file2.deleteOnExit();
        out2 = new JarOutputStream(new FileOutputStream(file2));
        u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        jarFile = new JarFile(file2);
        jarFile2 = new JarFile(compareFile);
        this.compareJarEntries(jarFile, jarFile2);
        entries = jarFile.entries();
        entries2 = jarFile2.entries();
        boolean inOrder = true;
        while (entries.hasMoreElements()) {
            String name2;
            JarEntry entry = entries.nextElement();
            PackingOptionsTest.assertNotNull((Object)entry);
            JarEntry entry2 = entries2.nextElement();
            String name = entry.getName();
            if (name.equals(name2 = entry2.getName())) continue;
            inOrder = false;
            break;
        }
        PackingOptionsTest.assertFalse((String)"Files are not expected to be in order", (boolean)inOrder);
    }

    public void testDeflateHint() {
        PackingOptions options = new PackingOptions();
        PackingOptionsTest.assertEquals((String)"keep", (String)options.getDeflateHint());
        options.setDeflateHint("true");
        PackingOptionsTest.assertEquals((String)"true", (String)options.getDeflateHint());
        options.setDeflateHint("false");
        PackingOptionsTest.assertEquals((String)"false", (String)options.getDeflateHint());
        try {
            options.setDeflateHint("hello");
            PackingOptionsTest.fail((String)"Should throw IllegalArgumentException for incorrect deflate hint");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testModificationTime() throws Exception {
        PackingOptions options = new PackingOptions();
        PackingOptionsTest.assertEquals((String)"keep", (String)options.getModificationTime());
        options.setModificationTime("latest");
        PackingOptionsTest.assertEquals((String)"latest", (String)options.getModificationTime());
        try {
            options.setModificationTime("true");
            PackingOptionsTest.fail((String)"Should throw IllegalArgumentException for incorrect mod time");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        this.file = File.createTempFile("sql", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        options = new PackingOptions();
        options.setGzip(false);
        Archive archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("sql", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        JarFile jarFile = new JarFile(file2);
        JarFile jarFile2 = new JarFile(compareFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        Enumeration<JarEntry> entries2 = jarFile2.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            PackingOptionsTest.assertNotNull((Object)entry);
            JarEntry entry2 = entries2.nextElement();
            String name = entry.getName();
            String name2 = entry2.getName();
            PackingOptionsTest.assertEquals((String)name, (String)name2);
            PackingOptionsTest.assertEquals((long)entry.getTime(), (long)entry2.getTime());
        }
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        this.file = File.createTempFile("sql", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        options = new PackingOptions();
        options.setGzip(false);
        options.setModificationTime("latest");
        archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        in2 = new FileInputStream(this.file);
        file2 = File.createTempFile("sql", ".jar");
        file2.deleteOnExit();
        out2 = new JarOutputStream(new FileOutputStream(file2));
        u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        jarFile = new JarFile(file2);
        jarFile2 = new JarFile(compareFile);
        entries = jarFile.entries();
        entries2 = jarFile2.entries();
        long modtime = -1L;
        boolean sameAsOriginal = true;
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            PackingOptionsTest.assertNotNull((Object)entry);
            JarEntry entry2 = entries2.nextElement();
            String name = entry.getName();
            if (!name.startsWith("META-INF")) {
                if (modtime == -1L) {
                    modtime = entry.getTime();
                } else {
                    PackingOptionsTest.assertEquals((long)modtime, (long)entry.getTime());
                }
            }
            if (entry2.getTime() == entry.getTime()) continue;
            sameAsOriginal = false;
        }
        PackingOptionsTest.assertFalse((String)"Some modtimes should have changed", (boolean)sameAsOriginal);
    }

    public void testLoggingOptions() throws Exception {
        PackingOptions options = new PackingOptions();
        PackingOptionsTest.assertFalse((boolean)options.isVerbose());
        PackingOptionsTest.assertNull((Object)options.getLogFile());
        options.setVerbose(true);
        PackingOptionsTest.assertTrue((boolean)options.isVerbose());
        options.setQuiet(true);
        PackingOptionsTest.assertFalse((boolean)options.isVerbose());
        File logFile = File.createTempFile("logfile", ".txt");
        logFile.deleteOnExit();
        options.setLogFile(logFile.getPath());
        PackingOptionsTest.assertEquals((String)logFile.getPath(), (String)options.getLogFile());
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
        this.file = File.createTempFile("helloworld", ".pack.gz");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        new Archive(this.in, this.out, options).pack();
        this.in.close();
        this.out.close();
        FileReader reader = new FileReader(logFile);
        PackingOptionsTest.assertFalse((boolean)reader.ready());
        reader.close();
        options.setVerbose(true);
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
        this.file = File.createTempFile("helloworld", ".pack.gz");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        new Archive(this.in, this.out, options).pack();
        this.in.close();
        this.out.close();
        reader = new FileReader(logFile);
        PackingOptionsTest.assertTrue((boolean)reader.ready());
        reader.close();
    }

    public void testSegmentLimits() throws IOException, Pack200Exception, URISyntaxException {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
        this.file = File.createTempFile("helloworld", ".pack.gz");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.setSegmentLimit(0L);
        Archive archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
        this.file = File.createTempFile("helloworld", ".pack.gz");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        options = new PackingOptions();
        options.setSegmentLimit(-1L);
        archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
        this.file = File.createTempFile("helloworld", ".pack.gz");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        options = new PackingOptions();
        options.setSegmentLimit(5000L);
        archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
    }

    public void testStripDebug() throws IOException, Pack200Exception, URISyntaxException {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        this.file = File.createTempFile("sql", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.setGzip(false);
        options.setStripDebug(true);
        Archive archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("sqloutNoDebug", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpackedNoDebug.jar").toURI());
        JarFile jarFile = new JarFile(file2);
        PackingOptionsTest.assertTrue((file2.length() < 250000L ? 1 : 0) != 0);
        JarFile jarFile2 = new JarFile(compareFile);
        this.compareFiles(jarFile, jarFile2);
    }

    public void testPassFiles() throws IOException, URISyntaxException, Pack200Exception {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        File file0 = File.createTempFile("sql", ".pack");
        file0.deleteOnExit();
        this.out = new FileOutputStream(file0);
        PackingOptions options = new PackingOptions();
        options.setGzip(false);
        Archive archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        this.file = File.createTempFile("sql", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        options = new PackingOptions();
        options.setGzip(false);
        options.addPassFile("bin/test/org/apache/harmony/sql/tests/java/sql/DatabaseMetaDataTest.class");
        PackingOptionsTest.assertTrue((boolean)options.isPassFile("bin/test/org/apache/harmony/sql/tests/java/sql/DatabaseMetaDataTest.class"));
        archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        File file2 = File.createTempFile("sql", ".pack");
        file2.deleteOnExit();
        this.out = new FileOutputStream(file2);
        options = new PackingOptions();
        options.setGzip(false);
        options.addPassFile("bin/test/org/apache/harmony/sql/tests/java/sql");
        PackingOptionsTest.assertTrue((boolean)options.isPassFile("bin/test/org/apache/harmony/sql/tests/java/sql/DatabaseMetaDataTest.class"));
        PackingOptionsTest.assertFalse((boolean)options.isPassFile("bin/test/org/apache/harmony/sql/tests/java/sqldata/SqlData.class"));
        archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        PackingOptionsTest.assertTrue((String)"If files are passed then the pack file should be larger", (this.file.length() > file0.length() ? 1 : 0) != 0);
        PackingOptionsTest.assertTrue((String)"If more files are passed then the pack file should be larger", (file2.length() > this.file.length() ? 1 : 0) != 0);
        FileInputStream in2 = new FileInputStream(this.file);
        File file3 = File.createTempFile("sql", ".jar");
        file3.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file3));
        org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        JarFile jarFile = new JarFile(file3);
        JarFile jarFile2 = new JarFile(compareFile);
        this.compareJarEntries(jarFile, jarFile2);
        FileInputStream in3 = new FileInputStream(file2);
        File file4 = File.createTempFile("sql", ".jar");
        file4.deleteOnExit();
        JarOutputStream out3 = new JarOutputStream(new FileOutputStream(file4));
        u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in3, out3);
        u2archive.unpack();
        jarFile = new JarFile(file4);
        jarFile2 = new JarFile(compareFile);
        this.compareJarEntries(jarFile, jarFile2);
    }

    public void testNewAttributes() throws Exception {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI()));
        this.file = File.createTempFile("unknown", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.addClassAttributeAction("Pack200", "I");
        Archive ar = new Archive(this.in, this.out, options);
        ar.pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("unknown", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        File compareFile = new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI());
        JarFile jarFile = new JarFile(file2);
        JarFile jarFile2 = new JarFile(compareFile);
        PackingOptionsTest.assertEquals((int)jarFile2.size(), (int)jarFile.size());
        this.compareJarEntries(jarFile, jarFile2);
    }

    public void testNewAttributes2() throws Exception {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/p200WithUnknownAttributes.jar").toURI()));
        this.file = File.createTempFile("unknown", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.addFieldAttributeAction("Pack200", "I");
        options.addMethodAttributeAction("Pack200", "I");
        options.addCodeAttributeAction("Pack200", "I");
        Archive ar = new Archive(this.in, this.out, options);
        ar.pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("unknown", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        File compareFile = new File(Archive.class.getResource("/pack200/p200WithUnknownAttributes.jar").toURI());
        JarFile jarFile = new JarFile(file2);
        JarFile jarFile2 = new JarFile(compareFile);
        PackingOptionsTest.assertEquals((int)jarFile2.size(), (int)jarFile.size());
        this.compareJarEntries(jarFile, jarFile2);
    }

    public void testErrorAttributes() throws Exception {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI()));
        this.file = File.createTempFile("unknown", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.addClassAttributeAction("Pack200", "error");
        Archive ar = new Archive(this.in, this.out, options);
        try {
            ar.pack();
            this.in.close();
            this.out.close();
            PackingOptionsTest.fail((String)"fail");
        }
        catch (Error e) {
            PackingOptionsTest.assertEquals((String)"Attribute Pack200 was found", (String)e.getMessage());
        }
    }

    public void testPassAttributes() throws Exception {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI()));
        this.file = File.createTempFile("unknown", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.addClassAttributeAction("Pack200", "pass");
        Archive ar = new Archive(this.in, this.out, options);
        ar.pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("unknown", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        File compareFile = new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI());
        JarFile jarFile = new JarFile(file2);
        JarFile jarFile2 = new JarFile(compareFile);
        PackingOptionsTest.assertEquals((int)jarFile2.size(), (int)jarFile.size());
        this.compareJarEntries(jarFile, jarFile2);
    }

    public void testE0() throws Pack200Exception, IOException, URISyntaxException {
        File f1 = new File(Archive.class.getResource("/pack200/jndi.jar").toURI());
        this.in = new JarFile(f1);
        this.file = File.createTempFile("jndiE0", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.setGzip(false);
        options.setEffort(0);
        Archive archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        this.compareFiles(new JarFile(f1), new JarFile(this.file));
    }

    private void compareJarEntries(JarFile jarFile, JarFile jarFile2) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            PackingOptionsTest.assertNotNull((Object)entry);
            String name = entry.getName();
            JarEntry entry2 = jarFile2.getJarEntry(name);
            PackingOptionsTest.assertNotNull((String)("Missing Entry: " + name), (Object)entry2);
        }
    }

    private void compareFiles(JarFile jarFile, JarFile jarFile2) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            PackingOptionsTest.assertNotNull((Object)entry);
            String name = entry.getName();
            JarEntry entry2 = jarFile2.getJarEntry(name);
            PackingOptionsTest.assertNotNull((String)("Missing Entry: " + name), (Object)entry2);
            if (name.equals("META-INF/MANIFEST.MF")) continue;
            InputStream ours = jarFile.getInputStream(entry);
            InputStream expected = jarFile2.getInputStream(entry2);
            BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
            BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));
            String line1 = reader1.readLine();
            String line2 = reader2.readLine();
            int i = 1;
            while (line1 != null || line2 != null) {
                PackingOptionsTest.assertEquals((String)("Unpacked files differ for " + name), (String)line2, (String)line1);
                line1 = reader1.readLine();
                line2 = reader2.readLine();
                ++i;
            }
            reader1.close();
            reader2.close();
        }
        jarFile.close();
        jarFile2.close();
    }
}

