/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.zstandard;

import org.apache.commons.compress.compressors.zstandard.ZstdUtils;
import org.junit.Assert;
import org.junit.Test;

public class ZstdUtilsTest {
    @Test
    public void testMatchesZstandardFrame() {
        byte[] data = new byte[]{40, -75, 47, -3};
        Assert.assertFalse((boolean)ZstdUtils.matches((byte[])data, (int)3));
        Assert.assertTrue((boolean)ZstdUtils.matches((byte[])data, (int)4));
        Assert.assertTrue((boolean)ZstdUtils.matches((byte[])data, (int)5));
        data[3] = 48;
        Assert.assertFalse((boolean)ZstdUtils.matches((byte[])data, (int)4));
    }

    @Test
    public void testMatchesSkippableFrame() {
        byte[] data = new byte[]{0, 42, 77, 24};
        Assert.assertFalse((boolean)ZstdUtils.matches((byte[])data, (int)4));
        for (int b = 80; b < 96; b = (int)((byte)(b + 1))) {
            data[0] = b;
            Assert.assertTrue((boolean)ZstdUtils.matches((byte[])data, (int)4));
        }
        Assert.assertFalse((boolean)ZstdUtils.matches((byte[])data, (int)3));
        Assert.assertTrue((boolean)ZstdUtils.matches((byte[])data, (int)5));
    }
}

