/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.MemoryLimitException;
import org.apache.commons.compress.MockEvilInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.utils.ByteUtils;
import org.junit.Assert;
import org.junit.Test;

public final class DetectCompressorTestCase {
    final CompressorStreamFactory factory = new CompressorStreamFactory();
    private static final CompressorStreamFactory factoryTrue = new CompressorStreamFactory(true);
    private static final CompressorStreamFactory factoryFalse = new CompressorStreamFactory(false);
    private static final CompressorStreamFactory factorySetTrue = new CompressorStreamFactory();
    private static final CompressorStreamFactory factorySetFalse;
    private final TestData[] tests = new TestData[]{new TestData("multiple.bz2", new char[]{'a', 'b'}, factoryTrue, true), new TestData("multiple.bz2", new char[]{'a', 'b'}, factorySetTrue, true), new TestData("multiple.bz2", new char[]{'a'}, factoryFalse, false), new TestData("multiple.bz2", new char[]{'a'}, factorySetFalse, false), new TestData("multiple.bz2", new char[]{'a'}, this.factory, false), new TestData("multiple.gz", new char[]{'a', 'b'}, factoryTrue, true), new TestData("multiple.gz", new char[]{'a', 'b'}, factorySetTrue, true), new TestData("multiple.gz", new char[]{'a'}, factoryFalse, false), new TestData("multiple.gz", new char[]{'a'}, factorySetFalse, false), new TestData("multiple.gz", new char[]{'a'}, this.factory, false), new TestData("multiple.xz", new char[]{'a', 'b'}, factoryTrue, true), new TestData("multiple.xz", new char[]{'a', 'b'}, factorySetTrue, true), new TestData("multiple.xz", new char[]{'a'}, factoryFalse, false), new TestData("multiple.xz", new char[]{'a'}, factorySetFalse, false), new TestData("multiple.xz", new char[]{'a'}, this.factory, false)};

    @Test
    public void testDetection() throws Exception {
        CompressorInputStream bzip2 = this.getStreamFor("bla.txt.bz2");
        Assert.assertNotNull((Object)bzip2);
        Assert.assertTrue((boolean)(bzip2 instanceof BZip2CompressorInputStream));
        CompressorInputStream gzip = this.getStreamFor("bla.tgz");
        Assert.assertNotNull((Object)gzip);
        Assert.assertTrue((boolean)(gzip instanceof GzipCompressorInputStream));
        CompressorInputStream pack200 = this.getStreamFor("bla.pack");
        Assert.assertNotNull((Object)pack200);
        Assert.assertTrue((boolean)(pack200 instanceof Pack200CompressorInputStream));
        CompressorInputStream xz = this.getStreamFor("bla.tar.xz");
        Assert.assertNotNull((Object)xz);
        Assert.assertTrue((boolean)(xz instanceof XZCompressorInputStream));
        CompressorInputStream zlib = this.getStreamFor("bla.tar.deflatez");
        Assert.assertNotNull((Object)zlib);
        Assert.assertTrue((boolean)(zlib instanceof DeflateCompressorInputStream));
        CompressorInputStream zstd = this.getStreamFor("bla.tar.zst");
        Assert.assertNotNull((Object)zstd);
        Assert.assertTrue((boolean)(zstd instanceof ZstdCompressorInputStream));
        try {
            this.factory.createCompressorInputStream((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));
            Assert.fail((String)"No exception thrown for an empty input stream");
        }
        catch (CompressorException compressorException) {
            // empty catch block
        }
    }

    @Test
    public void testDetect() throws Exception {
        Assert.assertEquals((Object)"bzip2", (Object)this.detect("bla.txt.bz2"));
        Assert.assertEquals((Object)"gz", (Object)this.detect("bla.tgz"));
        Assert.assertEquals((Object)"pack200", (Object)this.detect("bla.pack"));
        Assert.assertEquals((Object)"xz", (Object)this.detect("bla.tar.xz"));
        Assert.assertEquals((Object)"deflate", (Object)this.detect("bla.tar.deflatez"));
        Assert.assertEquals((Object)"lz4-framed", (Object)this.detect("bla.tar.lz4"));
        Assert.assertEquals((Object)"lzma", (Object)this.detect("bla.tar.lzma"));
        Assert.assertEquals((Object)"snappy-framed", (Object)this.detect("bla.tar.sz"));
        Assert.assertEquals((Object)"z", (Object)this.detect("bla.tar.Z"));
        Assert.assertEquals((Object)"zstd", (Object)this.detect("bla.tar.zst"));
        Assert.assertEquals((Object)"z", (Object)this.detect("COMPRESS-386"));
        Assert.assertEquals((Object)"lzma", (Object)this.detect("COMPRESS-382"));
        try {
            CompressorStreamFactory.detect((InputStream)new BufferedInputStream(new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY)));
            Assert.fail((String)"shouldn't be able to detect empty stream");
        }
        catch (CompressorException e) {
            Assert.assertEquals((Object)"No Compressor found for the stream signature.", (Object)e.getMessage());
        }
        try {
            CompressorStreamFactory.detect(null);
            Assert.fail((String)"shouldn't be able to detect null stream");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Stream must not be null.", (Object)e.getMessage());
        }
        try {
            CompressorStreamFactory.detect((InputStream)new BufferedInputStream(new MockEvilInputStream()));
            Assert.fail((String)"Expected IOException");
        }
        catch (CompressorException e) {
            Assert.assertEquals((Object)"IOException while reading signature.", (Object)e.getMessage());
        }
    }

    private String detect(String testFileName) throws IOException, CompressorException {
        String name = null;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(AbstractTestCase.getFile(testFileName).toPath(), new OpenOption[0]));){
            name = CompressorStreamFactory.detect((InputStream)is);
        }
        return name;
    }

    @Test(expected=MemoryLimitException.class)
    public void testLZMAMemoryLimit() throws Exception {
        this.getStreamFor("COMPRESS-382", 100);
    }

    @Test(expected=MemoryLimitException.class)
    public void testZMemoryLimit() throws Exception {
        this.getStreamFor("COMPRESS-386", 100);
    }

    @Test(expected=MemoryLimitException.class)
    public void testXZMemoryLimitOnRead() throws Exception {
        try (InputStream compressorIs = this.getStreamFor("bla.tar.xz", 100);){
            compressorIs.read();
        }
    }

    @Test(expected=MemoryLimitException.class)
    public void testXZMemoryLimitOnSkip() throws Exception {
        try (InputStream compressorIs = this.getStreamFor("bla.tar.xz", 100);){
            compressorIs.skip(10L);
        }
    }

    private InputStream getStreamFor(String fileName, int memoryLimitInKb) throws Exception {
        CompressorStreamFactory fac = new CompressorStreamFactory(true, memoryLimitInKb);
        BufferedInputStream is = new BufferedInputStream(Files.newInputStream(AbstractTestCase.getFile(fileName).toPath(), new OpenOption[0]));
        try {
            return fac.createCompressorInputStream((InputStream)is);
        }
        catch (CompressorException e) {
            if (e.getCause() != null && e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    @Test
    public void testOverride() {
        CompressorStreamFactory fac = new CompressorStreamFactory();
        Assert.assertFalse((boolean)fac.getDecompressConcatenated());
        fac.setDecompressConcatenated(true);
        Assert.assertTrue((boolean)fac.getDecompressConcatenated());
        fac = new CompressorStreamFactory(false);
        Assert.assertFalse((boolean)fac.getDecompressConcatenated());
        try {
            fac.setDecompressConcatenated(true);
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        fac = new CompressorStreamFactory(true);
        Assert.assertTrue((boolean)fac.getDecompressConcatenated());
        try {
            fac.setDecompressConcatenated(true);
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiples() throws Exception {
        for (int i = 0; i < this.tests.length; ++i) {
            TestData test = this.tests[i];
            CompressorStreamFactory fac = test.factory;
            Assert.assertNotNull((String)("Test entry " + i), (Object)fac);
            Assert.assertEquals((String)("Test entry " + i), (Object)test.concat, (Object)fac.getDecompressConcatenated());
            CompressorInputStream in = this.getStreamFor(test.fileName, fac);
            Assert.assertNotNull((String)("Test entry " + i), (Object)in);
            for (char entry : test.entryNames) {
                Assert.assertEquals((String)("Test entry" + i), (long)entry, (long)in.read());
            }
            Assert.assertEquals((long)0L, (long)in.available());
            Assert.assertEquals((long)-1L, (long)in.read());
        }
    }

    private CompressorInputStream getStreamFor(String resource) throws CompressorException, IOException {
        return this.factory.createCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(AbstractTestCase.getFile(resource).toPath(), new OpenOption[0])));
    }

    private CompressorInputStream getStreamFor(String resource, CompressorStreamFactory factory) throws CompressorException, IOException {
        return factory.createCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(AbstractTestCase.getFile(resource).toPath(), new OpenOption[0])));
    }

    static {
        factorySetTrue.setDecompressConcatenated(true);
        factorySetFalse = new CompressorStreamFactory();
        factorySetFalse.setDecompressConcatenated(false);
    }

    static class TestData {
        final String fileName;
        final char[] entryNames;
        final CompressorStreamFactory factory;
        final boolean concat;

        TestData(String name, char[] names, CompressorStreamFactory factory, boolean concat) {
            this.fileName = name;
            this.entryNames = names;
            this.factory = factory;
            this.concat = concat;
        }
    }
}

