/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.util.graph;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.hive.druid.org.apache.calcite.util.graph.DefaultEdge;
import org.apache.hive.druid.org.apache.calcite.util.graph.DirectedGraph;

public class BreadthFirstIterator<V, E extends DefaultEdge>
implements Iterator<V> {
    private final DirectedGraph<V, E> graph;
    private final Deque<V> deque = new ArrayDeque<V>();
    private final Set<V> set = new HashSet<V>();

    public BreadthFirstIterator(DirectedGraph<V, E> graph, V root) {
        this.graph = graph;
        this.deque.add(root);
    }

    public static <V, E extends DefaultEdge> Iterable<V> of(final DirectedGraph<V, E> graph, final V root) {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new BreadthFirstIterator(graph, root);
            }
        };
    }

    public static <V, E extends DefaultEdge> void reachable(Set<V> set, DirectedGraph<V, E> graph, V root) {
        ArrayDeque<Object> deque = new ArrayDeque<Object>();
        deque.add(root);
        set.add(root);
        while (!deque.isEmpty()) {
            Object v = deque.removeFirst();
            for (DefaultEdge e : graph.getOutwardEdges(v)) {
                Object target = e.target;
                if (!set.add(target)) continue;
                deque.addLast(target);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return !this.deque.isEmpty();
    }

    @Override
    public V next() {
        V v = this.deque.removeFirst();
        for (DefaultEdge e : this.graph.getOutwardEdges(v)) {
            Object target = e.target;
            if (!this.set.add(target)) continue;
            this.deque.addLast(target);
        }
        return v;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

