/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.type;

import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.type.ExplicitOperandTypeInference;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;

public abstract class InferTypes {
    public static final SqlOperandTypeInference FIRST_KNOWN = new SqlOperandTypeInference(){

        @Override
        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            RelDataType unknownType;
            RelDataType knownType = unknownType = callBinding.getValidator().getUnknownType();
            for (SqlNode operand : callBinding.operands()) {
                knownType = callBinding.getValidator().deriveType(callBinding.getScope(), operand);
                if (knownType.equals(unknownType)) continue;
                break;
            }
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = knownType;
            }
        }
    };
    public static final SqlOperandTypeInference RETURN_TYPE = new SqlOperandTypeInference(){

        @Override
        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = returnType.isStruct() ? returnType.getFieldList().get(i).getType() : returnType;
            }
        }
    };
    public static final SqlOperandTypeInference BOOLEAN = new SqlOperandTypeInference(){

        @Override
        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
        }
    };
    public static final SqlOperandTypeInference VARCHAR_1024 = new SqlOperandTypeInference(){

        @Override
        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = typeFactory.createSqlType(SqlTypeName.VARCHAR, 1024);
            }
        }
    };

    private InferTypes() {
    }

    public static SqlOperandTypeInference explicit(List<RelDataType> types) {
        return new ExplicitOperandTypeInference(ImmutableList.copyOf(types));
    }
}

