/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.util.Static;

public class SqlFilterOperator
extends SqlBinaryOperator {
    public SqlFilterOperator() {
        super("FILTER", SqlKind.FILTER, 2, true, ReturnTypes.ARG0_FORCE_NULLABLE, null, (SqlOperandTypeChecker)OperandTypes.ANY_ANY);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, this.getLeftPrec());
        writer.sep(this.getName());
        writer.sep("(");
        writer.sep("WHERE");
        ((SqlNode)call.operand(1)).unparse(writer, this.getRightPrec(), rightPrec);
        writer.sep(")");
        writer.endList(frame);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 2);
        SqlCall aggCall = (SqlCall)call.operand(0);
        if (!aggCall.getOperator().isAggregator()) {
            throw validator.newValidationError(aggCall, Static.RESOURCE.filterNonAggregate());
        }
        Object condition = call.operand(1);
        validator.validateAggregateParams(aggCall, (SqlNode)condition, scope);
        RelDataType type = validator.deriveType(scope, (SqlNode)condition);
        if (!SqlTypeUtil.inBooleanFamily(type)) {
            throw validator.newValidationError((SqlNode)condition, Static.RESOURCE.condMustBeBoolean("FILTER"));
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        this.validateOperands(validator, scope, call);
        Object agg = call.operand(0);
        if (!(agg instanceof SqlCall)) {
            throw new IllegalStateException("Argument to SqlOverOperator should be SqlCall, got " + agg.getClass() + ": " + agg);
        }
        SqlCall aggCall = (SqlCall)agg;
        SqlCallBinding opBinding = new SqlCallBinding(validator, scope, aggCall){

            @Override
            public int getGroupCount() {
                return 0;
            }
        };
        RelDataType ret = aggCall.getOperator().inferReturnType(opBinding);
        validator.setValidatedNodeType(call, ret);
        validator.setValidatedNodeType((SqlNode)agg, ret);
        return ret;
    }
}

