/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Aggregate;
import org.apache.hive.druid.org.apache.calcite.rel.core.AggregateCall;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.core.RelFactories;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;

public class AggregateProjectMergeRule
extends RelOptRule {
    public static final AggregateProjectMergeRule INSTANCE = new AggregateProjectMergeRule(Aggregate.class, Project.class, RelFactories.LOGICAL_BUILDER);

    public AggregateProjectMergeRule(Class<? extends Aggregate> aggregateClass, Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory) {
        super(AggregateProjectMergeRule.operand(aggregateClass, AggregateProjectMergeRule.operand(projectClass, AggregateProjectMergeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project;
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelNode x = AggregateProjectMergeRule.apply(call, aggregate, project = (Project)call.rel(1));
        if (x != null) {
            call.transformTo(x);
        }
    }

    public static RelNode apply(RelOptRuleCall call, Aggregate aggregate, Project project) {
        ArrayList<Integer> newKeys = Lists.newArrayList();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int key : aggregate.getGroupSet()) {
            RexNode rex = project.getProjects().get(key);
            if (rex instanceof RexInputRef) {
                int newKey = ((RexInputRef)rex).getIndex();
                newKeys.add(newKey);
                map.put(key, newKey);
                continue;
            }
            return null;
        }
        ImmutableBitSet newGroupSet = aggregate.getGroupSet().permute(map);
        ImmutableList<ImmutableBitSet> newGroupingSets = null;
        if (aggregate.indicator) {
            newGroupingSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute(aggregate.getGroupSets(), map));
        }
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            int newFilterArg;
            ImmutableList.Builder newArgs = ImmutableList.builder();
            for (int arg : aggregateCall.getArgList()) {
                RexNode rex = project.getProjects().get(arg);
                if (rex instanceof RexInputRef) {
                    newArgs.add((Object)((RexInputRef)rex).getIndex());
                    continue;
                }
                return null;
            }
            if (aggregateCall.filterArg >= 0) {
                RexNode rex = project.getProjects().get(aggregateCall.filterArg);
                if (!(rex instanceof RexInputRef)) {
                    return null;
                }
                newFilterArg = ((RexInputRef)rex).getIndex();
            } else {
                newFilterArg = -1;
            }
            aggCalls.add(aggregateCall.copy((List<Integer>)((Object)newArgs.build()), newFilterArg));
        }
        Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet(), project.getInput(), aggregate.indicator, newGroupSet, newGroupingSets, (List<AggregateCall>)((Object)aggCalls.build()));
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newAggregate);
        if (!newKeys.equals(newGroupSet.asList())) {
            ArrayList<Integer> posList = Lists.newArrayList();
            Iterator newFilterArg = newKeys.iterator();
            while (newFilterArg.hasNext()) {
                int newKey = (Integer)newFilterArg.next();
                posList.add(newGroupSet.indexOf(newKey));
            }
            if (aggregate.indicator) {
                newFilterArg = newKeys.iterator();
                while (newFilterArg.hasNext()) {
                    int newKey = (Integer)newFilterArg.next();
                    posList.add(aggregate.getGroupCount() + newGroupSet.indexOf(newKey));
                }
            }
            for (int i = newAggregate.getGroupCount() + newAggregate.getIndicatorCount(); i < newAggregate.getRowType().getFieldCount(); ++i) {
                posList.add(i);
            }
            relBuilder.project(relBuilder.fields((List<? extends Number>)posList));
        }
        return relBuilder.build();
    }
}

