/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rel2sql;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.calcite.linq4j.Ord;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.hive.druid.org.apache.calcite.rel.RelFieldCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.AggregateCall;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexLocalRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexProgram;
import org.apache.hive.druid.org.apache.calcite.sql.JoinType;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAggFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlBasicCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.hive.druid.org.apache.calcite.sql.SqlDialect;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlJoin;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlLiteral;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNodeList;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSelect;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSetOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlCase;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.type.BasicSqlType;
import org.apache.hive.druid.org.apache.calcite.sql.type.InferTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqlImplementor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlImplementor.class);
    public static final SqlParserPos POS = SqlParserPos.ZERO;
    public static final SqlFunction ORACLE_SUBSTR = new SqlFunction("SUBSTR", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, null, SqlFunctionCategory.STRING);
    public static final SqlFunction ISNULL_FUNCTION = new SqlFunction("ISNULL", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN, InferTypes.FIRST_KNOWN, OperandTypes.ANY, SqlFunctionCategory.SYSTEM);
    public final SqlDialect dialect;
    protected final Set<String> aliasSet = new LinkedHashSet<String>();
    protected final Map<String, SqlNode> ordinalMap = new HashMap<String, SqlNode>();

    protected SqlImplementor(SqlDialect dialect) {
        this.dialect = Preconditions.checkNotNull(dialect);
    }

    public abstract Result visitChild(int var1, RelNode var2);

    public static SqlNode rewriteSingleValueExpr(SqlNode aggCall, SqlDialect sqlDialect) {
        SqlCall elseExpr;
        Object wrappedOperand;
        SqlCall caseOperand;
        Object operand = ((SqlBasicCall)aggCall).operand(0);
        SqlCall countCall = SqlStdOperatorTable.COUNT.createCall(POS, new SqlNode[]{operand});
        SqlLiteral nullLiteral = SqlLiteral.createNull(POS);
        switch (sqlDialect.getDatabaseProduct()) {
            case MYSQL: 
            case HSQLDB: {
                SqlCall unionOperand;
                caseOperand = countCall;
                SqlNodeList selectList = new SqlNodeList(POS);
                selectList.add(nullLiteral);
                switch (sqlDialect.getDatabaseProduct()) {
                    case MYSQL: {
                        wrappedOperand = operand;
                        unionOperand = new SqlSelect(POS, SqlNodeList.EMPTY, selectList, null, null, null, null, SqlNodeList.EMPTY, null, null, null);
                        break;
                    }
                    default: {
                        wrappedOperand = SqlStdOperatorTable.MIN.createCall(POS, new SqlNode[]{operand});
                        unionOperand = SqlStdOperatorTable.VALUES.createCall(POS, SqlLiteral.createApproxNumeric("0", POS));
                    }
                }
                SqlCall unionAll = SqlStdOperatorTable.UNION_ALL.createCall(POS, unionOperand, unionOperand);
                SqlNodeList subQuery = new SqlNodeList(POS);
                subQuery.add(unionAll);
                SqlNodeList selectList2 = new SqlNodeList(POS);
                selectList2.add(nullLiteral);
                elseExpr = SqlStdOperatorTable.SCALAR_QUERY.createCall(POS, subQuery);
                break;
            }
            default: {
                LOGGER.debug("SINGLE_VALUE rewrite not supported for {}", (Object)sqlDialect.getDatabaseProduct());
                return aggCall;
            }
        }
        SqlNodeList whenList = new SqlNodeList(POS);
        whenList.add(SqlLiteral.createExactNumeric("0", POS));
        whenList.add(SqlLiteral.createExactNumeric("1", POS));
        SqlNodeList thenList = new SqlNodeList(POS);
        thenList.add(nullLiteral);
        thenList.add((SqlNode)wrappedOperand);
        SqlCase caseExpr = new SqlCase(POS, caseOperand, whenList, thenList, elseExpr);
        LOGGER.debug("SINGLE_VALUE rewritten into [{}]", (Object)caseExpr);
        return caseExpr;
    }

    public void addSelect(List<SqlNode> selectList, SqlNode node, RelDataType rowType) {
        String name = rowType.getFieldNames().get(selectList.size());
        String alias = SqlValidatorUtil.getAlias(node, -1);
        if (alias == null || !alias.equals(name)) {
            node = SqlStdOperatorTable.AS.createCall(POS, node, new SqlIdentifier(name, POS));
        }
        selectList.add(node);
    }

    public static boolean isStar(List<RexNode> exps, RelDataType inputRowType) {
        int i = 0;
        for (RexNode ref : exps) {
            if (!(ref instanceof RexInputRef)) {
                return false;
            }
            if (((RexInputRef)ref).getIndex() == i++) continue;
            return false;
        }
        return i == inputRowType.getFieldCount();
    }

    public static boolean isStar(RexProgram program) {
        int i = 0;
        for (RexLocalRef ref : program.getProjectList()) {
            if (ref.getIndex() == i++) continue;
            return false;
        }
        return i == program.getInputRowType().getFieldCount();
    }

    public Result setOpToSql(SqlSetOperator operator, RelNode rel) {
        Expressions.FluentList list = Expressions.list();
        for (Ord<RelNode> input : Ord.zip(rel.getInputs())) {
            Result result = this.visitChild(input.i, (RelNode)input.e);
            list.add(result.asSelect());
        }
        SqlCall node = operator.createCall(new SqlNodeList(list, POS));
        Expressions.FluentList<Clause> clauses = Expressions.list(Clause.SET_OP);
        return this.result(node, clauses, rel, null);
    }

    public static SqlNode convertConditionToSqlNode(RexNode node, Context leftContext, Context rightContext, int leftFieldCount) {
        if (!(node instanceof RexCall)) {
            throw new AssertionError(node);
        }
        switch (node.getKind()) {
            case AND: 
            case OR: {
                List<RexNode> operands = ((RexCall)node).getOperands();
                SqlOperator op = ((RexCall)node).getOperator();
                SqlNode sqlCondition = null;
                for (RexNode operand : operands) {
                    SqlNode x = SqlImplementor.convertConditionToSqlNode(operand, leftContext, rightContext, leftFieldCount);
                    if (sqlCondition == null) {
                        sqlCondition = x;
                        continue;
                    }
                    sqlCondition = op.createCall(POS, sqlCondition, x);
                }
                return sqlCondition;
            }
            case EQUALS: 
            case IS_NOT_DISTINCT_FROM: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                node = SqlImplementor.stripCastFromString(node);
                List<RexNode> operands = ((RexCall)node).getOperands();
                SqlOperator op = ((RexCall)node).getOperator();
                if (operands.size() == 2 && operands.get(0) instanceof RexInputRef && operands.get(1) instanceof RexInputRef) {
                    RexInputRef op0 = (RexInputRef)operands.get(0);
                    RexInputRef op1 = (RexInputRef)operands.get(1);
                    if (op0.getIndex() < leftFieldCount && op1.getIndex() >= leftFieldCount) {
                        return op.createCall(POS, leftContext.field(op0.getIndex()), rightContext.field(op1.getIndex() - leftFieldCount));
                    }
                    if (op1.getIndex() < leftFieldCount && op0.getIndex() >= leftFieldCount) {
                        return SqlImplementor.reverseOperatorDirection(op).createCall(POS, leftContext.field(op1.getIndex()), rightContext.field(op0.getIndex() - leftFieldCount));
                    }
                }
                Context joinContext = leftContext.implementor().joinContext(leftContext, rightContext);
                return joinContext.toSql(null, node);
            }
        }
        throw new AssertionError(node);
    }

    private static RexNode stripCastFromString(RexNode node) {
        switch (node.getKind()) {
            case EQUALS: 
            case IS_NOT_DISTINCT_FROM: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                RexCall call = (RexCall)node;
                RexNode o0 = (RexNode)call.operands.get(0);
                RexNode o1 = (RexNode)call.operands.get(1);
                if (o0.getKind() == SqlKind.CAST && o1.getKind() != SqlKind.CAST) {
                    RexNode o0b = ((RexCall)o0).getOperands().get(0);
                    switch (o0b.getType().getSqlTypeName()) {
                        case CHAR: 
                        case VARCHAR: {
                            return call.clone(call.getType(), ImmutableList.of(o0b, o1));
                        }
                    }
                }
                if (o1.getKind() != SqlKind.CAST || o0.getKind() == SqlKind.CAST) break;
                RexNode o1b = ((RexCall)o1).getOperands().get(0);
                switch (o1b.getType().getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        return call.clone(call.getType(), ImmutableList.of(o0, o1b));
                    }
                }
            }
        }
        return node;
    }

    private static SqlOperator reverseOperatorDirection(SqlOperator op) {
        switch (op.kind) {
            case GREATER_THAN: {
                return SqlStdOperatorTable.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlStdOperatorTable.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
            }
            case EQUALS: 
            case IS_NOT_DISTINCT_FROM: 
            case NOT_EQUALS: {
                return op;
            }
        }
        throw new AssertionError(op);
    }

    public static JoinType joinType(JoinRelType joinType) {
        switch (joinType) {
            case LEFT: {
                return JoinType.LEFT;
            }
            case RIGHT: {
                return JoinType.RIGHT;
            }
            case INNER: {
                return JoinType.INNER;
            }
            case FULL: {
                return JoinType.FULL;
            }
        }
        throw new AssertionError((Object)joinType);
    }

    public Result result(SqlNode node, Collection<Clause> clauses, RelNode rel, Map<String, RelDataType> aliases) {
        assert (aliases == null || aliases.size() < 2 || aliases instanceof LinkedHashMap || aliases instanceof ImmutableMap) : "must use a Map implementation that preserves order";
        String alias2 = SqlValidatorUtil.getAlias(node, -1);
        String alias3 = alias2 != null ? alias2 : "t";
        String alias4 = SqlValidatorUtil.uniquify(alias3, this.aliasSet, SqlValidatorUtil.EXPR_SUGGESTER);
        if (!(aliases == null || aliases.isEmpty() || this.dialect.hasImplicitTableAlias() && aliases.size() <= 1)) {
            return new Result(node, clauses, alias4, aliases);
        }
        String alias5 = alias2 == null || !alias2.equals(alias4) || !this.dialect.hasImplicitTableAlias() ? alias4 : null;
        return new Result(node, clauses, alias5, ImmutableMap.of(alias4, rel.getRowType()));
    }

    public Result result(SqlNode join, Result leftResult, Result rightResult) {
        ImmutableMap.Builder<String, RelDataType> builder = ImmutableMap.builder();
        this.collectAliases(builder, join, Iterables.concat(leftResult.aliases.values(), rightResult.aliases.values()).iterator());
        return new Result(join, Expressions.list(Clause.FROM), null, builder.build());
    }

    private void collectAliases(ImmutableMap.Builder<String, RelDataType> builder, SqlNode node, Iterator<RelDataType> aliases) {
        if (node instanceof SqlJoin) {
            SqlJoin join = (SqlJoin)node;
            this.collectAliases(builder, join.getLeft(), aliases);
            this.collectAliases(builder, join.getRight(), aliases);
        } else {
            String alias = SqlValidatorUtil.getAlias(node, -1);
            assert (alias != null);
            builder.put(alias, aliases.next());
        }
    }

    SqlSelect wrapSelect(SqlNode node) {
        assert (node instanceof SqlJoin || node instanceof SqlIdentifier || node instanceof SqlCall && (((SqlCall)node).getOperator() instanceof SqlSetOperator || ((SqlCall)node).getOperator() == SqlStdOperatorTable.AS)) : node;
        return new SqlSelect(POS, SqlNodeList.EMPTY, null, node, null, null, null, SqlNodeList.EMPTY, null, null, null);
    }

    private static int computeFieldCount(Map<String, RelDataType> aliases) {
        int x = 0;
        for (RelDataType type : aliases.values()) {
            x += type.getFieldCount();
        }
        return x;
    }

    public Context aliasContext(Map<String, RelDataType> aliases, boolean qualified) {
        return new AliasContext(aliases, qualified);
    }

    public Context joinContext(Context leftContext, Context rightContext) {
        return new JoinContext(leftContext, rightContext);
    }

    public static enum Clause {
        FROM,
        WHERE,
        GROUP_BY,
        HAVING,
        SELECT,
        SET_OP,
        ORDER_BY,
        FETCH,
        OFFSET;

    }

    public class Builder {
        private final RelNode rel;
        final List<Clause> clauses;
        private final SqlSelect select;
        public final Context context;
        private final Map<String, RelDataType> aliases;

        public Builder(RelNode rel, List<Clause> clauses, SqlSelect select, Context context, Map<String, RelDataType> aliases) {
            this.rel = rel;
            this.clauses = clauses;
            this.select = select;
            this.context = context;
            this.aliases = aliases;
        }

        public void setSelect(SqlNodeList nodeList) {
            this.select.setSelectList(nodeList);
        }

        public void setWhere(SqlNode node) {
            assert (this.clauses.contains((Object)Clause.WHERE));
            this.select.setWhere(node);
        }

        public void setGroupBy(SqlNodeList nodeList) {
            assert (this.clauses.contains((Object)Clause.GROUP_BY));
            this.select.setGroupBy(nodeList);
        }

        public void setOrderBy(SqlNodeList nodeList) {
            assert (this.clauses.contains((Object)Clause.ORDER_BY));
            this.select.setOrderBy(nodeList);
        }

        public void setFetch(SqlNode fetch) {
            assert (this.clauses.contains((Object)Clause.FETCH));
            this.select.setFetch(fetch);
        }

        public void setOffset(SqlNode offset) {
            assert (this.clauses.contains((Object)Clause.OFFSET));
            this.select.setOffset(offset);
        }

        public void addOrderItem(List<SqlNode> orderByList, RelFieldCollation field) {
            if (field.nullDirection != RelFieldCollation.NullDirection.UNSPECIFIED && SqlImplementor.this.dialect.getDatabaseProduct() == SqlDialect.DatabaseProduct.MYSQL) {
                orderByList.add(ISNULL_FUNCTION.createCall(POS, this.context.field(field.getFieldIndex())));
                field = new RelFieldCollation(field.getFieldIndex(), field.getDirection(), RelFieldCollation.NullDirection.UNSPECIFIED);
            }
            orderByList.add(this.context.toSql(field));
        }

        public Result result() {
            return SqlImplementor.this.result(this.select, this.clauses, this.rel, this.aliases);
        }
    }

    public class Result {
        final SqlNode node;
        private final String neededAlias;
        private final Map<String, RelDataType> aliases;
        final Expressions.FluentList<Clause> clauses;

        public Result(SqlNode node, Collection<Clause> clauses, String neededAlias, Map<String, RelDataType> aliases) {
            this.node = node;
            this.neededAlias = neededAlias;
            this.aliases = aliases;
            this.clauses = Expressions.list(clauses);
        }

        public Builder builder(RelNode rel, Clause ... clauses) {
            Context newContext;
            SqlSelect select;
            Clause maxClause = this.maxClause();
            boolean needNew = false;
            ImmutableSet<Clause> nonWrapSet = ImmutableSet.of(Clause.SELECT);
            for (Clause clause : clauses) {
                if (maxClause.ordinal() <= clause.ordinal() && (!maxClause.equals((Object)clause) || nonWrapSet.contains((Object)clause))) continue;
                needNew = true;
            }
            Expressions.FluentList<Clause> clauseList = Expressions.list();
            if (needNew) {
                select = this.subSelect();
            } else {
                select = this.asSelect();
                clauseList.addAll(this.clauses);
            }
            clauseList.appendAll(clauses);
            final SqlNodeList selectList = select.getSelectList();
            if (selectList != null) {
                newContext = new Context(selectList.size()){

                    @Override
                    public SqlNode field(int ordinal) {
                        SqlNode selectItem = selectList.get(ordinal);
                        switch (selectItem.getKind()) {
                            case AS: {
                                return ((SqlCall)selectItem).operand(0);
                            }
                        }
                        return selectItem;
                    }
                };
            } else {
                boolean qualified = !SqlImplementor.this.dialect.hasImplicitTableAlias() || this.aliases.size() > 1;
                newContext = needNew ? SqlImplementor.this.aliasContext(ImmutableMap.of(this.neededAlias, rel.getRowType()), qualified) : SqlImplementor.this.aliasContext(this.aliases, qualified);
            }
            return new Builder(rel, clauseList, select, newContext, needNew ? null : this.aliases);
        }

        public Clause maxClause() {
            Clause maxClause = null;
            for (Clause clause : this.clauses) {
                if (maxClause != null && clause.ordinal() <= maxClause.ordinal()) continue;
                maxClause = clause;
            }
            assert (maxClause != null);
            return maxClause;
        }

        public SqlNode asFrom() {
            if (this.neededAlias != null) {
                return SqlStdOperatorTable.AS.createCall(POS, this.node, new SqlIdentifier(this.neededAlias, POS));
            }
            return this.node;
        }

        public SqlSelect subSelect() {
            return SqlImplementor.this.wrapSelect(this.asFrom());
        }

        public SqlSelect asSelect() {
            if (this.node instanceof SqlSelect) {
                return (SqlSelect)this.node;
            }
            if (!SqlImplementor.this.dialect.hasImplicitTableAlias()) {
                return SqlImplementor.this.wrapSelect(this.asFrom());
            }
            return SqlImplementor.this.wrapSelect(this.node);
        }

        public SqlNode asQuery() {
            if (this.node instanceof SqlCall && ((SqlCall)this.node).getOperator() instanceof SqlSetOperator) {
                return this.node;
            }
            return this.asSelect();
        }

        public Context qualifiedContext() {
            return SqlImplementor.this.aliasContext(this.aliases, true);
        }
    }

    class JoinContext
    extends Context {
        private final Context leftContext;
        private final Context rightContext;

        private JoinContext(Context leftContext, Context rightContext) {
            super(leftContext.fieldCount + rightContext.fieldCount);
            this.leftContext = leftContext;
            this.rightContext = rightContext;
        }

        @Override
        public SqlNode field(int ordinal) {
            if (ordinal < this.leftContext.fieldCount) {
                return this.leftContext.field(ordinal);
            }
            return this.rightContext.field(ordinal - this.leftContext.fieldCount);
        }
    }

    public class AliasContext
    extends Context {
        private final boolean qualified;
        private final Map<String, RelDataType> aliases;

        protected AliasContext(Map<String, RelDataType> aliases, boolean qualified) {
            super(SqlImplementor.computeFieldCount(aliases));
            this.aliases = aliases;
            this.qualified = qualified;
        }

        @Override
        public SqlNode field(int ordinal) {
            for (Map.Entry<String, RelDataType> alias : this.aliases.entrySet()) {
                List<RelDataTypeField> fields = alias.getValue().getFieldList();
                if (ordinal < fields.size()) {
                    RelDataTypeField field = fields.get(ordinal);
                    SqlNode mappedSqlNode = SqlImplementor.this.ordinalMap.get(field.getName().toLowerCase());
                    if (mappedSqlNode != null) {
                        return mappedSqlNode;
                    }
                    return new SqlIdentifier(!this.qualified ? ImmutableList.of(field.getName()) : ImmutableList.of(alias.getKey(), field.getName()), POS);
                }
                ordinal -= fields.size();
            }
            throw new AssertionError((Object)("field ordinal " + ordinal + " out of range " + this.aliases));
        }
    }

    public abstract class Context {
        final int fieldCount;
        private final boolean ignoreCast;

        protected Context(int fieldCount) {
            this(fieldCount, false);
        }

        protected Context(int fieldCount, boolean ignoreCast) {
            this.fieldCount = fieldCount;
            this.ignoreCast = ignoreCast;
        }

        public abstract SqlNode field(int var1);

        public SqlNode toSql(RexProgram program, RexNode rex) {
            switch (rex.getKind()) {
                case LOCAL_REF: {
                    int index = ((RexLocalRef)rex).getIndex();
                    return this.toSql(program, program.getExprList().get(index));
                }
                case INPUT_REF: {
                    return this.field(((RexInputRef)rex).getIndex());
                }
                case LITERAL: {
                    RexLiteral literal = (RexLiteral)rex;
                    if (literal.getTypeName() == SqlTypeName.SYMBOL) {
                        Enum symbol = (Enum)((Object)literal.getValue());
                        return SqlLiteral.createSymbol(symbol, POS);
                    }
                    switch (literal.getTypeName().getFamily()) {
                        case CHARACTER: {
                            return SqlLiteral.createCharString((String)literal.getValue2(), POS);
                        }
                        case NUMERIC: 
                        case EXACT_NUMERIC: {
                            return SqlLiteral.createExactNumeric(literal.getValue().toString(), POS);
                        }
                        case APPROXIMATE_NUMERIC: {
                            return SqlLiteral.createApproxNumeric(literal.getValue().toString(), POS);
                        }
                        case BOOLEAN: {
                            return SqlLiteral.createBoolean((Boolean)literal.getValue(), POS);
                        }
                        case DATE: {
                            return SqlLiteral.createDate((Calendar)literal.getValue(), POS);
                        }
                        case TIME: {
                            return SqlLiteral.createTime((Calendar)literal.getValue(), literal.getType().getPrecision(), POS);
                        }
                        case TIMESTAMP: {
                            return SqlLiteral.createTimestamp((Calendar)literal.getValue(), literal.getType().getPrecision(), POS);
                        }
                        case ANY: 
                        case NULL: {
                            switch (literal.getTypeName()) {
                                case NULL: {
                                    return SqlLiteral.createNull(POS);
                                }
                            }
                        }
                    }
                    throw new AssertionError((Object)(literal + ": " + (Object)((Object)literal.getTypeName())));
                }
                case CASE: {
                    SqlNode valueNode;
                    RexCall caseCall = (RexCall)rex;
                    List<SqlNode> caseNodeList = this.toSql(program, caseCall.getOperands());
                    Expressions.FluentList whenList = Expressions.list();
                    Expressions.FluentList thenList = Expressions.list();
                    if (caseNodeList.size() % 2 == 0) {
                        valueNode = caseNodeList.get(0);
                        for (int i = 1; i < caseNodeList.size() - 1; i += 2) {
                            whenList.add(caseNodeList.get(i));
                            thenList.add(caseNodeList.get(i + 1));
                        }
                    } else {
                        valueNode = null;
                        for (int i = 0; i < caseNodeList.size() - 1; i += 2) {
                            whenList.add(caseNodeList.get(i));
                            thenList.add(caseNodeList.get(i + 1));
                        }
                    }
                    SqlNode elseNode = caseNodeList.get(caseNodeList.size() - 1);
                    return new SqlCase(POS, valueNode, new SqlNodeList(whenList, POS), new SqlNodeList(thenList, POS), elseNode);
                }
            }
            RexCall call = (RexCall)SqlImplementor.stripCastFromString(rex);
            SqlOperator op = call.getOperator();
            List<SqlNode> nodeList = this.toSql(program, call.getOperands());
            switch (call.getKind()) {
                case CAST: {
                    if (this.ignoreCast) {
                        assert (nodeList.size() == 1);
                        return nodeList.get(0);
                    }
                    nodeList.add(this.toSql(call.getType()));
                }
            }
            if (op instanceof SqlBinaryOperator && nodeList.size() > 2) {
                return this.createLeftCall(op, nodeList);
            }
            if (op == SqlStdOperatorTable.SUBSTRING) {
                switch (SqlImplementor.this.dialect.getDatabaseProduct()) {
                    case ORACLE: {
                        return ORACLE_SUBSTR.createCall(new SqlNodeList(nodeList, POS));
                    }
                }
            }
            return op.createCall(new SqlNodeList(nodeList, POS));
        }

        private SqlNode createLeftCall(SqlOperator op, List<SqlNode> nodeList) {
            if (nodeList.size() == 2) {
                return op.createCall(new SqlNodeList(nodeList, POS));
            }
            List<SqlNode> butLast = Util.skipLast(nodeList);
            SqlNode last = nodeList.get(nodeList.size() - 1);
            SqlNode call = this.createLeftCall(op, butLast);
            return op.createCall(new SqlNodeList(ImmutableList.of(call, last), POS));
        }

        private SqlNode toSql(RelDataType type) {
            switch (SqlImplementor.this.dialect.getDatabaseProduct()) {
                case MYSQL: {
                    switch (type.getSqlTypeName()) {
                        case VARCHAR: {
                            return new SqlDataTypeSpec(new SqlIdentifier("CHAR", POS), type.getPrecision(), -1, null, null, POS);
                        }
                        case INTEGER: {
                            return new SqlDataTypeSpec(new SqlIdentifier("_UNSIGNED", POS), type.getPrecision(), -1, null, null, POS);
                        }
                    }
                }
            }
            if (type instanceof BasicSqlType) {
                return new SqlDataTypeSpec(new SqlIdentifier(type.getSqlTypeName().name(), POS), type.getPrecision(), type.getScale(), type.getCharset() != null && SqlImplementor.this.dialect.supportsCharSet() ? type.getCharset().name() : null, null, POS);
            }
            return SqlTypeUtil.convertTypeToSpec(type);
        }

        private List<SqlNode> toSql(RexProgram program, List<RexNode> operandList) {
            ArrayList<SqlNode> list = new ArrayList<SqlNode>();
            for (RexNode rex : operandList) {
                list.add(this.toSql(program, rex));
            }
            return list;
        }

        public List<SqlNode> fieldList() {
            return new AbstractList<SqlNode>(){

                @Override
                public SqlNode get(int index) {
                    return Context.this.field(index);
                }

                @Override
                public int size() {
                    return Context.this.fieldCount;
                }
            };
        }

        public SqlNode toSql(AggregateCall aggCall) {
            SqlAggFunction op = aggCall.getAggregation();
            if (op instanceof SqlSumEmptyIsZeroAggFunction) {
                op = SqlStdOperatorTable.SUM;
            }
            Expressions.FluentList<SqlNode> operands = Expressions.list();
            for (int arg : aggCall.getArgList()) {
                operands.add(this.field(arg));
            }
            return op.createCall(aggCall.isDistinct() ? SqlSelectKeyword.DISTINCT.symbol(POS) : null, POS, operands.toArray(new SqlNode[operands.size()]));
        }

        public SqlNode toSql(RelFieldCollation collation) {
            SqlNode node = this.field(collation.getFieldIndex());
            switch (collation.getDirection()) {
                case DESCENDING: 
                case STRICTLY_DESCENDING: {
                    node = SqlStdOperatorTable.DESC.createCall(POS, node);
                }
            }
            if (collation.nullDirection != SqlImplementor.this.dialect.defaultNullDirection(collation.direction)) {
                switch (collation.nullDirection) {
                    case FIRST: {
                        node = SqlStdOperatorTable.NULLS_FIRST.createCall(POS, node);
                        break;
                    }
                    case LAST: {
                        node = SqlStdOperatorTable.NULLS_LAST.createCall(POS, node);
                    }
                }
            }
            return node;
        }

        public SqlImplementor implementor() {
            return SqlImplementor.this;
        }
    }
}

