/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.enumerable;

import java.util.List;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelTrait;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.hive.druid.org.apache.calcite.rel.RelDistribution;
import org.apache.hive.druid.org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Filter;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMdDistribution;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;

public class EnumerableFilter
extends Filter
implements EnumerableRel {
    public EnumerableFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        super(cluster, traitSet, child, condition);
        assert (this.getConvention() instanceof EnumerableConvention);
    }

    public static EnumerableFilter create(final RelNode input, RexNode condition) {
        RelOptCluster cluster = input.getCluster();
        final RelMetadataQuery mq = RelMetadataQuery.instance();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

            @Override
            public List<RelCollation> get() {
                return RelMdCollation.filter(mq, input);
            }
        }).replaceIf(RelDistributionTraitDef.INSTANCE, new Supplier<RelDistribution>(){

            @Override
            public RelDistribution get() {
                return RelMdDistribution.filter(mq, input);
            }
        });
        return new EnumerableFilter(cluster, traitSet, input, condition);
    }

    @Override
    public EnumerableFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new EnumerableFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        throw new UnsupportedOperationException();
    }
}

