/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.metrics;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.hive.druid.com.metamx.common.collect.CountingMap;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.com.metamx.metrics.AbstractMonitor;
import org.apache.hive.druid.io.druid.client.DruidServerConfig;
import org.apache.hive.druid.io.druid.server.coordination.ServerManager;
import org.apache.hive.druid.io.druid.server.coordination.ZkCoordinator;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class HistoricalMetricsMonitor
extends AbstractMonitor {
    private final DruidServerConfig serverConfig;
    private final ServerManager serverManager;
    private final ZkCoordinator zkCoordinator;

    @Inject
    public HistoricalMetricsMonitor(DruidServerConfig serverConfig, ServerManager serverManager, ZkCoordinator zkCoordinator) {
        this.serverConfig = serverConfig;
        this.serverManager = serverManager;
        this.zkCoordinator = zkCoordinator;
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder;
        String dataSource;
        emitter.emit(new ServiceMetricEvent.Builder().build("segment/max", this.serverConfig.getMaxSize()));
        CountingMap<String> pendingDeleteSizes = new CountingMap<String>();
        for (DataSegment dataSegment : this.zkCoordinator.getPendingDeleteSnapshot()) {
            pendingDeleteSizes.add(dataSegment.getDataSource(), dataSegment.getSize());
        }
        for (Map.Entry entry : pendingDeleteSizes.entrySet()) {
            dataSource = (String)entry.getKey();
            long pendingDeleteSize = (Long)entry.getValue();
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).setDimension("tier", this.serverConfig.getTier()).setDimension("priority", String.valueOf(this.serverConfig.getPriority())).build("segment/pendingDelete", pendingDeleteSize));
        }
        for (Map.Entry entry : this.serverManager.getDataSourceSizes().entrySet()) {
            dataSource = (String)entry.getKey();
            long used = (Long)entry.getValue();
            builder = new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).setDimension("tier", this.serverConfig.getTier()).setDimension("priority", String.valueOf(this.serverConfig.getPriority()));
            emitter.emit(builder.build("segment/used", used));
            double usedPercent = this.serverConfig.getMaxSize() == 0L ? 0.0 : (double)used / (double)this.serverConfig.getMaxSize();
            emitter.emit(builder.build("segment/usedPercent", usedPercent));
        }
        for (Map.Entry entry : this.serverManager.getDataSourceCounts().entrySet()) {
            dataSource = (String)entry.getKey();
            long count = (Long)entry.getValue();
            builder = new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).setDimension("tier", this.serverConfig.getTier()).setDimension("priority", String.valueOf(this.serverConfig.getPriority()));
            emitter.emit(builder.build("segment/count", count));
        }
        return true;
    }
}

