/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.collections.CountingMap;

public class CoordinatorStats {
    private final Map<String, CountingMap<String>> perTierStats = Maps.newHashMap();
    private final CountingMap<String> globalStats = new CountingMap();

    public Map<String, CountingMap<String>> getPerTierStats() {
        return this.perTierStats;
    }

    public CountingMap<String> getGlobalStats() {
        return this.globalStats;
    }

    public void addToTieredStat(String statName, String tier, long value) {
        CountingMap<String> theStat = this.perTierStats.get(statName);
        if (theStat == null) {
            theStat = new CountingMap();
            this.perTierStats.put(statName, theStat);
        }
        theStat.add(tier, value);
    }

    public void addToGlobalStat(String statName, long value) {
        this.globalStats.add(statName, value);
    }

    public CoordinatorStats accumulate(CoordinatorStats stats) {
        for (Map.Entry<String, CountingMap<String>> entry : stats.perTierStats.entrySet()) {
            CountingMap<String> theStat = this.perTierStats.get(entry.getKey());
            if (theStat == null) {
                theStat = new CountingMap();
                this.perTierStats.put(entry.getKey(), theStat);
            }
            for (Map.Entry tiers : entry.getValue().entrySet()) {
                theStat.add((String)tiers.getKey(), ((AtomicLong)tiers.getValue()).get());
            }
        }
        for (Map.Entry<String, CountingMap<String>> entry : stats.globalStats.entrySet()) {
            this.globalStats.add(entry.getKey(), ((AtomicLong)((Object)entry.getValue())).get());
        }
        return this;
    }
}

