/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.segment.column.DictionaryEncodedColumn;
import org.apache.hive.druid.io.druid.segment.column.SimpleDictionaryEncodedColumn;
import org.apache.hive.druid.io.druid.segment.data.CachingIndexed;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedMultivalue;

public class DictionaryEncodedColumnSupplier
implements Supplier<DictionaryEncodedColumn> {
    private final GenericIndexed<String> dictionary;
    private final Supplier<IndexedInts> singleValuedColumn;
    private final Supplier<IndexedMultivalue<IndexedInts>> multiValuedColumn;
    private final int lookupCacheSize;

    public DictionaryEncodedColumnSupplier(GenericIndexed<String> dictionary, Supplier<IndexedInts> singleValuedColumn, Supplier<IndexedMultivalue<IndexedInts>> multiValuedColumn, int lookupCacheSize) {
        this.dictionary = dictionary;
        this.singleValuedColumn = singleValuedColumn;
        this.multiValuedColumn = multiValuedColumn;
        this.lookupCacheSize = lookupCacheSize;
    }

    @Override
    public DictionaryEncodedColumn get() {
        return new SimpleDictionaryEncodedColumn(this.singleValuedColumn != null ? this.singleValuedColumn.get() : null, this.multiValuedColumn != null ? this.multiValuedColumn.get() : null, new CachingIndexed<String>(this.dictionary, this.lookupCacheSize));
    }
}

