/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.firehose;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.data.input.Firehose;
import org.apache.hive.druid.io.druid.data.input.FirehoseFactory;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.impl.InputRowParser;

public class CombiningFirehoseFactory
implements FirehoseFactory<InputRowParser> {
    private static final EmittingLogger log = new EmittingLogger(CombiningFirehoseFactory.class);
    private final List<FirehoseFactory> delegateFactoryList;

    @JsonCreator
    public CombiningFirehoseFactory(@JsonProperty(value="delegates") List<FirehoseFactory> delegateFactoryList) {
        Preconditions.checkArgument(!delegateFactoryList.isEmpty());
        this.delegateFactoryList = delegateFactoryList;
    }

    @Override
    public Firehose connect(InputRowParser parser) throws IOException {
        return new CombiningFirehose(parser);
    }

    @JsonProperty(value="delegates")
    public List<FirehoseFactory> getDelegateFactoryList() {
        return this.delegateFactoryList;
    }

    public class CombiningFirehose
    implements Firehose {
        private final InputRowParser parser;
        private final Iterator<FirehoseFactory> firehoseFactoryIterator;
        private volatile Firehose currentFirehose;

        public CombiningFirehose(InputRowParser parser) throws IOException {
            this.firehoseFactoryIterator = CombiningFirehoseFactory.this.delegateFactoryList.iterator();
            this.parser = parser;
            this.nextFirehose();
        }

        private void nextFirehose() {
            if (this.firehoseFactoryIterator.hasNext()) {
                try {
                    if (this.currentFirehose != null) {
                        this.currentFirehose.close();
                    }
                    this.currentFirehose = this.firehoseFactoryIterator.next().connect(this.parser);
                }
                catch (IOException e) {
                    if (this.currentFirehose != null) {
                        try {
                            this.currentFirehose.close();
                        }
                        catch (IOException e2) {
                            log.error(e, "Unable to close currentFirehose!", new Object[0]);
                            throw Throwables.propagate(e2);
                        }
                    }
                    throw Throwables.propagate(e);
                }
            }
        }

        @Override
        public boolean hasMore() {
            return this.currentFirehose.hasMore();
        }

        @Override
        public InputRow nextRow() {
            InputRow rv = this.currentFirehose.nextRow();
            if (!this.currentFirehose.hasMore()) {
                this.nextFirehose();
            }
            return rv;
        }

        @Override
        public Runnable commit() {
            return this.currentFirehose.commit();
        }

        @Override
        public void close() throws IOException {
            this.currentFirehose.close();
        }
    }
}

