/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.hive.druid.com.metamx.common.MapUtils;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentMover;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class OmniDataSegmentMover
implements DataSegmentMover {
    private final Map<String, DataSegmentMover> movers;

    @Inject
    public OmniDataSegmentMover(Map<String, DataSegmentMover> movers) {
        this.movers = movers;
    }

    @Override
    public DataSegment move(DataSegment segment, Map<String, Object> targetLoadSpec) throws SegmentLoadingException {
        return this.getMover(segment).move(segment, targetLoadSpec);
    }

    private DataSegmentMover getMover(DataSegment segment) throws SegmentLoadingException {
        String type = MapUtils.getString(segment.getLoadSpec(), "type");
        DataSegmentMover mover = this.movers.get(type);
        if (mover == null) {
            throw new SegmentLoadingException("Unknown loader type[%s].  Known types are %s", type, this.movers.keySet());
        }
        return mover;
    }
}

