/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.com.metamx.collections.spatial.search.Bound;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherFactory;
import org.apache.hive.druid.io.druid.segment.incremental.SpatialDimensionRowTransformer;

public class SpatialFilter
implements Filter {
    private final String dimension;
    private final Bound bound;

    public SpatialFilter(String dimension, Bound bound) {
        this.dimension = Preconditions.checkNotNull(dimension, "dimension");
        this.bound = Preconditions.checkNotNull(bound, "bound");
    }

    @Override
    public ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector) {
        Iterable<ImmutableBitmap> search = selector.getSpatialIndex(this.dimension).search(this.bound);
        return selector.getBitmapFactory().union(search);
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                return new Predicate<String>(){

                    @Override
                    public boolean apply(String input) {
                        if (input == null) {
                            return false;
                        }
                        float[] coordinate = SpatialDimensionRowTransformer.decode(input);
                        return SpatialFilter.this.bound.contains(coordinate);
                    }
                };
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        return false;
                    }
                };
            }
        });
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }
}

