/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;

public abstract class FixedSizeCompressedObjectStrategy<T extends Buffer>
extends CompressedObjectStrategy<T> {
    private final int sizePer;

    protected FixedSizeCompressedObjectStrategy(ByteOrder order, CompressedObjectStrategy.BufferConverter<T> converter, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        super(order, converter, compression);
        this.sizePer = sizePer;
    }

    public int getSize() {
        return this.sizePer;
    }

    @Override
    protected ByteBuffer bufferFor(T val) {
        return ByteBuffer.allocate(this.converter.sizeOf(this.getSize())).order(this.order);
    }

    @Override
    protected void decompress(ByteBuffer buffer, int numBytes, ByteBuffer buf) {
        this.decompressor.decompress(buffer, numBytes, buf, this.converter.sizeOf(this.getSize()));
    }
}

