/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.data.CompressedIntsIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressedVSizeIntsIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.data.CompressedVSizeIntsIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.MultiValueIndexedIntsWriter;

public class CompressedVSizeIndexedV3Writer
extends MultiValueIndexedIntsWriter {
    private static final byte VERSION = 3;
    private static final List<Integer> EMPTY_LIST = new ArrayList<Integer>();
    private final CompressedIntsIndexedWriter offsetWriter;
    private final CompressedVSizeIntsIndexedWriter valueWriter;
    private int offset;

    public static CompressedVSizeIndexedV3Writer create(IOPeon ioPeon, String filenameBase, int maxValue, CompressedObjectStrategy.CompressionStrategy compression) {
        return new CompressedVSizeIndexedV3Writer(new CompressedIntsIndexedWriter(ioPeon, String.format("%s.offsets", filenameBase), 16384, IndexIO.BYTE_ORDER, compression), new CompressedVSizeIntsIndexedWriter(ioPeon, String.format("%s.values", filenameBase), maxValue, CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForValue(maxValue), IndexIO.BYTE_ORDER, compression));
    }

    public CompressedVSizeIndexedV3Writer(CompressedIntsIndexedWriter offsetWriter, CompressedVSizeIntsIndexedWriter valueWriter) {
        this.offsetWriter = offsetWriter;
        this.valueWriter = valueWriter;
        this.offset = 0;
    }

    @Override
    public void open() throws IOException {
        this.offsetWriter.open();
        this.valueWriter.open();
    }

    @Override
    protected void addValues(List<Integer> vals) throws IOException {
        if (vals == null) {
            vals = EMPTY_LIST;
        }
        this.offsetWriter.add(this.offset);
        for (Integer val : vals) {
            this.valueWriter.add(val);
        }
        this.offset += vals.size();
    }

    @Override
    public void close() throws IOException {
        try {
            this.offsetWriter.add(this.offset);
        }
        finally {
            this.offsetWriter.close();
            this.valueWriter.close();
        }
    }

    @Override
    public long getSerializedSize() {
        return 1L + this.offsetWriter.getSerializedSize() + this.valueWriter.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{3}));
        this.offsetWriter.writeToChannel(channel);
        this.valueWriter.writeToChannel(channel);
    }
}

