/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hive.druid.com.metamx.common.Pair;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;

public class CachingIndexed<T>
implements Indexed<T>,
Closeable {
    public static final int INITIAL_CACHE_CAPACITY = 16384;
    private static final Logger log = new Logger(CachingIndexed.class);
    private final GenericIndexed.BufferIndexed delegate;
    private final SizedLRUMap<Integer, T> cachedValues;

    public CachingIndexed(GenericIndexed<T> delegate, int lookupCacheSize) {
        this.delegate = delegate.singleThreaded();
        if (lookupCacheSize > 0) {
            log.debug("Allocating column cache of max size[%d]", lookupCacheSize);
            this.cachedValues = new SizedLRUMap(16384, lookupCacheSize);
        } else {
            this.cachedValues = null;
        }
    }

    @Override
    public Class<? extends T> getClazz() {
        return this.delegate.getClazz();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public T get(int index) {
        if (this.cachedValues != null) {
            T cached = this.cachedValues.getValue(index);
            if (cached != null) {
                return cached;
            }
            Object value = this.delegate.get(index);
            this.cachedValues.put(index, value, this.delegate.getLastValueSize());
            return value;
        }
        return this.delegate.get(index);
    }

    @Override
    public int indexOf(T value) {
        return this.delegate.indexOf(value);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public void close() throws IOException {
        if (this.cachedValues != null) {
            log.debug("Closing column cache", new Object[0]);
            this.cachedValues.clear();
        }
    }

    private static class SizedLRUMap<K, V>
    extends LinkedHashMap<K, Pair<Integer, V>> {
        private final int maxBytes;
        private int numBytes = 0;

        public SizedLRUMap(int initialCapacity, int maxBytes) {
            super(initialCapacity, 0.75f, true);
            this.maxBytes = maxBytes;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, Pair<Integer, V>> eldest) {
            if (this.numBytes > this.maxBytes) {
                this.numBytes -= ((Integer)eldest.getValue().lhs).intValue();
                return true;
            }
            return false;
        }

        public void put(K key, V value, int size) {
            int totalSize = size + 48;
            this.numBytes += totalSize;
            super.put(key, new Pair<Integer, V>(totalSize, value));
        }

        public V getValue(Object key) {
            Pair sizeValuePair = (Pair)super.get(key);
            return sizeValuePair == null ? null : (V)sizeValuePair.rhs;
        }
    }
}

