/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.column;

import java.io.IOException;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.metamx.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.segment.column.DictionaryEncodedColumn;
import org.apache.hive.druid.io.druid.segment.data.CachingIndexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedMultivalue;

public class SimpleDictionaryEncodedColumn
implements DictionaryEncodedColumn<String> {
    private final IndexedInts column;
    private final IndexedMultivalue<IndexedInts> multiValueColumn;
    private final CachingIndexed<String> cachedLookups;

    public SimpleDictionaryEncodedColumn(IndexedInts singleValueColumn, IndexedMultivalue<IndexedInts> multiValueColumn, CachingIndexed<String> cachedLookups) {
        this.column = singleValueColumn;
        this.multiValueColumn = multiValueColumn;
        this.cachedLookups = cachedLookups;
    }

    @Override
    public int length() {
        return this.hasMultipleValues() ? this.multiValueColumn.size() : this.column.size();
    }

    @Override
    public boolean hasMultipleValues() {
        return this.column == null;
    }

    @Override
    public int getSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public IndexedInts getMultiValueRow(int rowNum) {
        return (IndexedInts)this.multiValueColumn.get(rowNum);
    }

    @Override
    public String lookupName(int id) {
        return Strings.emptyToNull(this.cachedLookups.get(id));
    }

    @Override
    public int lookupId(String name) {
        return this.cachedLookups.indexOf(name);
    }

    @Override
    public int getCardinality() {
        return this.cachedLookups.size();
    }

    @Override
    public void close() throws IOException {
        CloseQuietly.close(this.cachedLookups);
        if (this.column != null) {
            this.column.close();
        }
        if (this.multiValueColumn != null) {
            this.multiValueColumn.close();
        }
    }
}

