/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.topn.BaseTopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TopNParams;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNResultBuilder;
import org.apache.hive.druid.io.druid.segment.Capabilities;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;

public class TimeExtractionTopNAlgorithm
extends BaseTopNAlgorithm<int[], Map<String, Aggregator[]>, TopNParams> {
    public static final int[] EMPTY_INTS = new int[0];
    private final TopNQuery query;

    public TimeExtractionTopNAlgorithm(Capabilities capabilities, TopNQuery query) {
        super(capabilities);
        this.query = query;
    }

    @Override
    public TopNParams makeInitParams(DimensionSelector dimSelector, Cursor cursor) {
        return new TopNParams(dimSelector, cursor, Integer.MAX_VALUE);
    }

    @Override
    protected int[] makeDimValSelector(TopNParams params, int numProcessed, int numToProcess) {
        return EMPTY_INTS;
    }

    @Override
    protected int[] updateDimValSelector(int[] dimValSelector, int numProcessed, int numToProcess) {
        return dimValSelector;
    }

    @Override
    protected Map<String, Aggregator[]> makeDimValAggregateStore(TopNParams params) {
        return Maps.newHashMap();
    }

    @Override
    protected void scanAndAggregate(TopNParams params, int[] dimValSelector, Map<String, Aggregator[]> aggregatesStore, int numProcessed) {
        Cursor cursor = params.getCursor();
        DimensionSelector dimSelector = params.getDimSelector();
        while (!cursor.isDone()) {
            String key = dimSelector.lookupName(dimSelector.getRow().get(0));
            Aggregator[] theAggregators = aggregatesStore.get(key);
            if (theAggregators == null) {
                theAggregators = TimeExtractionTopNAlgorithm.makeAggregators(cursor, this.query.getAggregatorSpecs());
                aggregatesStore.put(key, theAggregators);
            }
            for (Aggregator aggregator : theAggregators) {
                aggregator.aggregate();
            }
            cursor.advance();
        }
    }

    @Override
    protected void updateResults(TopNParams params, int[] dimValSelector, Map<String, Aggregator[]> aggregatesStore, TopNResultBuilder resultBuilder) {
        for (Map.Entry<String, Aggregator[]> entry : aggregatesStore.entrySet()) {
            Aggregator[] aggs = entry.getValue();
            if (aggs == null || aggs.length <= 0) continue;
            Object[] vals = new Object[aggs.length];
            for (int i = 0; i < aggs.length; ++i) {
                vals[i] = aggs[i].get();
            }
            resultBuilder.addEntry(entry.getKey(), entry.getKey(), vals);
        }
    }

    @Override
    protected void closeAggregators(Map<String, Aggregator[]> stringMap) {
        for (Aggregator[] aggregators : stringMap.values()) {
            for (Aggregator agg : aggregators) {
                agg.close();
            }
        }
    }

    @Override
    public void cleanup(TopNParams params) {
    }
}

