/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.timeseries;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hive.druid.com.metamx.common.guava.nary.BinaryFn;
import org.apache.hive.druid.io.druid.granularity.AllGranularity;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;

public class TimeseriesBinaryFn
implements BinaryFn<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> {
    private final QueryGranularity gran;
    private final List<AggregatorFactory> aggregations;

    public TimeseriesBinaryFn(QueryGranularity granularity, List<AggregatorFactory> aggregations) {
        this.gran = granularity;
        this.aggregations = aggregations;
    }

    @Override
    public Result<TimeseriesResultValue> apply(Result<TimeseriesResultValue> arg1, Result<TimeseriesResultValue> arg2) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        TimeseriesResultValue arg1Val = arg1.getValue();
        TimeseriesResultValue arg2Val = arg2.getValue();
        LinkedHashMap<String, Object> retVal = new LinkedHashMap<String, Object>();
        for (AggregatorFactory factory : this.aggregations) {
            String metricName = factory.getName();
            retVal.put(metricName, factory.combine(arg1Val.getMetric(metricName), arg2Val.getMetric(metricName)));
        }
        return this.gran instanceof AllGranularity ? new Result<TimeseriesResultValue>(arg1.getTimestamp(), new TimeseriesResultValue(retVal)) : new Result<TimeseriesResultValue>(this.gran.toDateTime(this.gran.truncate(arg1.getTimestamp().getMillis())), new TimeseriesResultValue(retVal));
    }
}

