/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.search;

import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.io.druid.query.ChainedExecutionQueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.search.SearchQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.search.SearchQueryRunner;
import org.apache.hive.druid.io.druid.query.search.SearchResultValue;
import org.apache.hive.druid.io.druid.query.search.search.SearchQuery;
import org.apache.hive.druid.io.druid.segment.Segment;

public class SearchQueryRunnerFactory
implements QueryRunnerFactory<Result<SearchResultValue>, SearchQuery> {
    private final SearchQueryQueryToolChest toolChest;
    private final QueryWatcher queryWatcher;

    @Inject
    public SearchQueryRunnerFactory(SearchQueryQueryToolChest toolChest, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<SearchResultValue>> createRunner(Segment segment) {
        return new SearchQueryRunner(segment);
    }

    @Override
    public QueryRunner<Result<SearchResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<SearchResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<SearchResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<SearchResultValue>, SearchQuery> getToolchest() {
        return this.toolChest;
    }
}

