/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.Pair;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.BaseSequence;
import org.apache.hive.druid.com.metamx.common.guava.CloseQuietly;
import org.apache.hive.druid.com.metamx.common.guava.FilteredSequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.io.druid.collections.BlockingPool;
import org.apache.hive.druid.io.druid.collections.ReferenceCountingResourceHolder;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.ResourceLimitExceededException;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherFactory;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;
import org.apache.hive.druid.io.druid.segment.filter.BooleanValueMatcher;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class GroupByRowProcessor {
    public static Sequence<Row> process(Query queryParam, Sequence<Row> rows, GroupByQueryConfig config, final BlockingPool<ByteBuffer> mergeBufferPool, final ObjectMapper spillMapper) {
        final GroupByQuery query = (GroupByQuery)queryParam;
        final GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        final AggregatorFactory[] aggregatorFactories = new AggregatorFactory[query.getAggregatorSpecs().size()];
        for (int i = 0; i < query.getAggregatorSpecs().size(); ++i) {
            aggregatorFactories[i] = query.getAggregatorSpecs().get(i);
        }
        final File temporaryStorageDirectory = new File(System.getProperty("java.io.tmpdir"), String.format("druid-groupBy-%s_%s", UUID.randomUUID(), query.getId()));
        Number queryTimeout = query.getContextValue("timeout", null);
        final long timeout = queryTimeout == null ? 0x3FFFFFFFFFFFFFFFL : queryTimeout.longValue();
        final List<Interval> queryIntervals = query.getIntervals();
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimFilter()));
        final RowBasedValueMatcherFactory filterMatcherFactory = new RowBasedValueMatcherFactory();
        final ValueMatcher filterMatcher = filter == null ? new BooleanValueMatcher(true) : filter.makeMatcher(filterMatcherFactory);
        final FilteredSequence<Row> filteredSequence = new FilteredSequence<Row>(rows, new Predicate<Row>(){

            @Override
            public boolean apply(Row input) {
                boolean inInterval = false;
                DateTime rowTime = input.getTimestamp();
                for (Interval queryInterval : queryIntervals) {
                    if (!queryInterval.contains((ReadableInstant)rowTime)) continue;
                    inInterval = true;
                }
                if (!inInterval) {
                    return false;
                }
                filterMatcherFactory.setRow(input);
                return filterMatcher.matches();
            }
        });
        return new BaseSequence<Row, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row>>(new BaseSequence.IteratorMaker<Row, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row>>(){

            @Override
            public CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> make() {
                ArrayList<Closeable> closeOnFailure = Lists.newArrayList();
                try {
                    ReferenceCountingResourceHolder mergeBufferHolder;
                    final LimitedTemporaryStorage temporaryStorage = new LimitedTemporaryStorage(temporaryStorageDirectory, querySpecificConfig.getMaxOnDiskStorage());
                    closeOnFailure.add(temporaryStorage);
                    try {
                        if (timeout <= 0L || (mergeBufferHolder = mergeBufferPool.take(timeout)) == null) {
                            throw new QueryInterruptedException(new TimeoutException());
                        }
                        closeOnFailure.add(mergeBufferHolder);
                    }
                    catch (InterruptedException e) {
                        throw new QueryInterruptedException(e);
                    }
                    Pair<Grouper<RowBasedGrouperHelper.RowBasedKey>, Accumulator<Grouper<RowBasedGrouperHelper.RowBasedKey>, Row>> pair = RowBasedGrouperHelper.createGrouperAccumulatorPair(query, true, querySpecificConfig, (ByteBuffer)mergeBufferHolder.get(), -1, temporaryStorage, spillMapper, aggregatorFactories);
                    final Grouper grouper = (Grouper)pair.lhs;
                    Accumulator accumulator = (Accumulator)pair.rhs;
                    closeOnFailure.add(grouper);
                    Grouper retVal = filteredSequence.accumulate(grouper, accumulator);
                    if (retVal != grouper) {
                        throw new ResourceLimitExceededException("Grouping resources exhausted");
                    }
                    return RowBasedGrouperHelper.makeGrouperIterator(grouper, query, new Closeable(){

                        @Override
                        public void close() throws IOException {
                            grouper.close();
                            mergeBufferHolder.close();
                            CloseQuietly.close(temporaryStorage);
                        }
                    });
                }
                catch (Throwable e) {
                    for (Closeable closeable : Lists.reverse(closeOnFailure)) {
                        CloseQuietly.close(closeable);
                    }
                    throw e;
                }
            }

            @Override
            public void cleanup(CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> iterFromMake) {
                iterFromMake.close();
            }
        });
    }

    private static class RowBasedValueMatcherFactory
    implements ValueMatcherFactory {
        private Row row;

        private RowBasedValueMatcherFactory() {
        }

        public void setRow(Row row) {
            this.row = row;
        }

        @Override
        public ValueMatcher makeValueMatcher(final String dimension, final Comparable value) {
            if (dimension.equals("__time")) {
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        return value.equals(RowBasedValueMatcherFactory.this.row.getTimestampFromEpoch());
                    }
                };
            }
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    return RowBasedValueMatcherFactory.this.row.getDimension(dimension).contains(value);
                }
            };
        }

        @Override
        public ValueMatcher makeValueMatcher(final String dimension, final DruidPredicateFactory predicateFactory) {
            if (dimension.equals("__time")) {
                return new ValueMatcher(){
                    final DruidLongPredicate predicate;
                    {
                        this.predicate = predicateFactory.makeLongPredicate();
                    }

                    @Override
                    public boolean matches() {
                        return this.predicate.applyLong(RowBasedValueMatcherFactory.this.row.getTimestampFromEpoch());
                    }
                };
            }
            return new ValueMatcher(){
                final Predicate<String> predicate;
                {
                    this.predicate = predicateFactory.makeStringPredicate();
                }

                @Override
                public boolean matches() {
                    List<String> values = RowBasedValueMatcherFactory.this.row.getDimension(dimension);
                    for (String value : values) {
                        if (!this.predicate.apply(value)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

