/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.Pair;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.BaseSequence;
import org.apache.hive.druid.com.metamx.common.guava.CloseQuietly;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.collections.BlockingPool;
import org.apache.hive.druid.io.druid.collections.ReferenceCountingResourceHolder;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.query.AbstractPrioritizedCallable;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.ChainedExecutionQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.ResourceLimitExceededException;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;

public class GroupByMergingQueryRunnerV2
implements QueryRunner {
    private static final Logger log = new Logger(GroupByMergingQueryRunnerV2.class);
    private static final String CTX_KEY_MERGE_RUNNERS_USING_CHAINED_EXECUTION = "mergeRunnersUsingChainedExecution";
    private final GroupByQueryConfig config;
    private final Iterable<QueryRunner<Row>> queryables;
    private final ListeningExecutorService exec;
    private final QueryWatcher queryWatcher;
    private final int concurrencyHint;
    private final BlockingPool<ByteBuffer> mergeBufferPool;
    private final ObjectMapper spillMapper;

    public GroupByMergingQueryRunnerV2(GroupByQueryConfig config, ExecutorService exec, QueryWatcher queryWatcher, Iterable<QueryRunner<Row>> queryables, int concurrencyHint, BlockingPool<ByteBuffer> mergeBufferPool, ObjectMapper spillMapper) {
        this.config = config;
        this.exec = MoreExecutors.listeningDecorator(exec);
        this.queryWatcher = queryWatcher;
        this.queryables = Iterables.unmodifiableIterable(Iterables.filter(queryables, Predicates.notNull()));
        this.concurrencyHint = concurrencyHint;
        this.mergeBufferPool = mergeBufferPool;
        this.spillMapper = spillMapper;
    }

    public Sequence<Row> run(Query queryParam, Map responseContext) {
        final GroupByQuery query = (GroupByQuery)queryParam;
        final GroupByQueryConfig querySpecificConfig = this.config.withOverrides(query);
        boolean forceChainedExecution = query.getContextBoolean(CTX_KEY_MERGE_RUNNERS_USING_CHAINED_EXECUTION, false);
        Query queryForRunners = query.withOverriddenContext(ImmutableMap.of(CTX_KEY_MERGE_RUNNERS_USING_CHAINED_EXECUTION, true));
        if (BaseQuery.getContextBySegment(query, false) || forceChainedExecution) {
            return new ChainedExecutionQueryRunner<Row>((ExecutorService)this.exec, this.queryWatcher, this.queryables).run(query, responseContext);
        }
        final AggregatorFactory[] combiningAggregatorFactories = new AggregatorFactory[query.getAggregatorSpecs().size()];
        for (int i = 0; i < query.getAggregatorSpecs().size(); ++i) {
            combiningAggregatorFactories[i] = query.getAggregatorSpecs().get(i).getCombiningFactory();
        }
        final File temporaryStorageDirectory = new File(System.getProperty("java.io.tmpdir"), String.format("druid-groupBy-%s_%s", UUID.randomUUID(), query.getId()));
        final int priority = BaseQuery.getContextPriority(query, 0);
        Number queryTimeout = query.getContextValue("timeout", null);
        final long timeoutAt = queryTimeout == null ? 0x3FFFFFFFFFFFFFFFL : System.currentTimeMillis() + queryTimeout.longValue();
        return new BaseSequence<Row, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row>>(new BaseSequence.IteratorMaker<Row, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row>>((GroupByQuery)queryForRunners, responseContext){
            final /* synthetic */ GroupByQuery val$queryForRunners;
            final /* synthetic */ Map val$responseContext;
            {
                this.val$queryForRunners = groupByQuery2;
                this.val$responseContext = map;
            }

            @Override
            public CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> make() {
                final ArrayList resources = Lists.newArrayList();
                try {
                    ReferenceCountingResourceHolder mergeBufferHolder;
                    LimitedTemporaryStorage temporaryStorage = new LimitedTemporaryStorage(temporaryStorageDirectory, querySpecificConfig.getMaxOnDiskStorage());
                    ReferenceCountingResourceHolder<LimitedTemporaryStorage> temporaryStorageHolder = ReferenceCountingResourceHolder.fromCloseable(temporaryStorage);
                    resources.add(temporaryStorageHolder);
                    try {
                        long timeout = timeoutAt - System.currentTimeMillis();
                        if (timeout <= 0L || (mergeBufferHolder = GroupByMergingQueryRunnerV2.this.mergeBufferPool.take(timeout)) == null) {
                            throw new QueryInterruptedException(new TimeoutException());
                        }
                        resources.add(mergeBufferHolder);
                    }
                    catch (InterruptedException e) {
                        throw new QueryInterruptedException(e);
                    }
                    Pair<Grouper<RowBasedGrouperHelper.RowBasedKey>, Accumulator<Grouper<RowBasedGrouperHelper.RowBasedKey>, Row>> pair = RowBasedGrouperHelper.createGrouperAccumulatorPair(query, false, GroupByMergingQueryRunnerV2.this.config, (ByteBuffer)mergeBufferHolder.get(), GroupByMergingQueryRunnerV2.this.concurrencyHint, temporaryStorage, GroupByMergingQueryRunnerV2.this.spillMapper, combiningAggregatorFactories);
                    final Grouper grouper = (Grouper)pair.lhs;
                    final Accumulator accumulator = (Accumulator)pair.rhs;
                    final ReferenceCountingResourceHolder<Grouper> grouperHolder = ReferenceCountingResourceHolder.fromCloseable(grouper);
                    resources.add(grouperHolder);
                    ListenableFuture<List<Boolean>> futures = Futures.allAsList(Lists.newArrayList(Iterables.transform(GroupByMergingQueryRunnerV2.this.queryables, new Function<QueryRunner<Row>, ListenableFuture<Boolean>>(){

                        @Override
                        public ListenableFuture<Boolean> apply(final QueryRunner<Row> input) {
                            if (input == null) {
                                throw new ISE("Null queryRunner! Looks to be some segment unmapping action happening", new Object[0]);
                            }
                            return GroupByMergingQueryRunnerV2.this.exec.submit(new AbstractPrioritizedCallable<Boolean>(priority){

                                /*
                                 * Exception decompiling
                                 */
                                @Override
                                public Boolean call() throws Exception {
                                    /*
                                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                     * 
                                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                     */
                                    throw new IllegalStateException("Decompilation failed");
                                }
                            });
                        }
                    })));
                    GroupByMergingQueryRunnerV2.this.waitForFutureCompletion(query, futures, timeoutAt - System.currentTimeMillis());
                    return RowBasedGrouperHelper.makeGrouperIterator(grouper, query, new Closeable(){

                        @Override
                        public void close() throws IOException {
                            for (Closeable closeable : Lists.reverse(resources)) {
                                CloseQuietly.close(closeable);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    for (Closeable closeable : Lists.reverse(resources)) {
                        CloseQuietly.close(closeable);
                    }
                    throw e;
                }
            }

            @Override
            public void cleanup(CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> iterFromMake) {
                iterFromMake.close();
            }
        });
    }

    private void waitForFutureCompletion(GroupByQuery query, ListenableFuture<List<Boolean>> future, long timeout) {
        try {
            if (this.queryWatcher != null) {
                this.queryWatcher.registerQuery(query, future);
            }
            if (timeout <= 0L) {
                throw new TimeoutException();
            }
            List results = (List)future.get(timeout, TimeUnit.MILLISECONDS);
            for (Boolean result : results) {
                if (result.booleanValue()) continue;
                future.cancel(true);
                throw new ResourceLimitExceededException("Grouping resources exhausted");
            }
        }
        catch (InterruptedException e) {
            log.warn(e, "Query interrupted, cancelling pending results, query id [%s]", query.getId());
            future.cancel(true);
            throw new QueryInterruptedException(e);
        }
        catch (CancellationException e) {
            throw new QueryInterruptedException(e);
        }
        catch (TimeoutException e) {
            log.info("Query timeout, cancelling pending results for query id [%s]", query.getId());
            future.cancel(true);
            throw new QueryInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    static /* synthetic */ Logger access$500() {
        return log;
    }
}

