/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.extraction;

import java.nio.ByteBuffer;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.query.extraction.DimExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;

@JsonTypeName(value="upper")
public class UpperExtractionFn
extends DimExtractionFn {
    private final Locale locale;
    @JsonProperty
    private final String localeString;

    public UpperExtractionFn(@JsonProperty(value="locale") String localeString) {
        this.localeString = localeString;
        this.locale = localeString == null ? Locale.getDefault() : Locale.forLanguageTag(localeString);
    }

    @Override
    @Nullable
    public String apply(String key) {
        if (Strings.isNullOrEmpty(key)) {
            return null;
        }
        return key.toUpperCase(this.locale);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] localeBytes = StringUtils.toUtf8(Strings.nullToEmpty(this.localeString));
        return ByteBuffer.allocate(2 + localeBytes.length).put((byte)11).put((byte)-1).put(localeBytes).array();
    }
}

