/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.datasourcemetadata;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.guava.BaseSequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.ChainedExecutionQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.datasourcemetadata.DataSourceMetadataQuery;
import org.apache.hive.druid.io.druid.query.datasourcemetadata.DataSourceMetadataResultValue;
import org.apache.hive.druid.io.druid.query.datasourcemetadata.DataSourceQueryQueryToolChest;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;

public class DataSourceMetadataQueryRunnerFactory
implements QueryRunnerFactory<Result<DataSourceMetadataResultValue>, DataSourceMetadataQuery> {
    private static final DataSourceQueryQueryToolChest toolChest = new DataSourceQueryQueryToolChest();
    private final QueryWatcher queryWatcher;

    @Inject
    public DataSourceMetadataQueryRunnerFactory(QueryWatcher queryWatcher) {
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<DataSourceMetadataResultValue>> createRunner(Segment segment) {
        return new DataSourceMetadataQueryRunner(segment);
    }

    @Override
    public QueryRunner<Result<DataSourceMetadataResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<DataSourceMetadataResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<DataSourceMetadataResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<DataSourceMetadataResultValue>, DataSourceMetadataQuery> getToolchest() {
        return toolChest;
    }

    private static class DataSourceMetadataQueryRunner
    implements QueryRunner<Result<DataSourceMetadataResultValue>> {
        private final StorageAdapter adapter;

        public DataSourceMetadataQueryRunner(Segment segment) {
            this.adapter = segment.asStorageAdapter();
        }

        @Override
        public Sequence<Result<DataSourceMetadataResultValue>> run(Query<Result<DataSourceMetadataResultValue>> input, Map<String, Object> responseContext) {
            if (!(input instanceof DataSourceMetadataQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", input.getClass().getCanonicalName(), DataSourceMetadataQuery.class);
            }
            final DataSourceMetadataQuery legacyQuery = (DataSourceMetadataQuery)input;
            return new BaseSequence<Result<DataSourceMetadataResultValue>, Iterator<Result<DataSourceMetadataResultValue>>>(new BaseSequence.IteratorMaker<Result<DataSourceMetadataResultValue>, Iterator<Result<DataSourceMetadataResultValue>>>(){

                @Override
                public Iterator<Result<DataSourceMetadataResultValue>> make() {
                    if (DataSourceMetadataQueryRunner.this.adapter == null) {
                        throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
                    }
                    return legacyQuery.buildResult(DataSourceMetadataQueryRunner.this.adapter.getInterval().getStart(), DataSourceMetadataQueryRunner.this.adapter.getMaxIngestedEventTime()).iterator();
                }

                @Override
                public void cleanup(Iterator<Result<DataSourceMetadataResultValue>> toClean) {
                }
            });
        }
    }
}

