/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.Comparator;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.query.Result;

public class ResultGranularTimestampComparator<T>
implements Comparator<Result<T>> {
    private final QueryGranularity gran;

    public ResultGranularTimestampComparator(QueryGranularity granularity) {
        this.gran = granularity;
    }

    @Override
    public int compare(Result<T> r1, Result<T> r2) {
        return Longs.compare(this.gran.truncate(r1.getTimestamp().getMillis()), this.gran.truncate(r2.getTimestamp().getMillis()));
    }

    public static <T> Ordering<Result<T>> create(QueryGranularity granularity, boolean descending) {
        ResultGranularTimestampComparator<T> comparator = new ResultGranularTimestampComparator<T>(granularity);
        return descending ? Ordering.from(comparator).reverse() : Ordering.from(comparator);
    }
}

