/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.metamx.common.guava.ResourceClosingSequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.joda.time.Interval;

public class QueryRunnerHelper {
    private static final Logger log = new Logger(QueryRunnerHelper.class);

    public static Aggregator[] makeAggregators(Cursor cursor, List<AggregatorFactory> aggregatorSpecs) {
        Aggregator[] aggregators = new Aggregator[aggregatorSpecs.size()];
        int aggregatorIndex = 0;
        for (AggregatorFactory spec : aggregatorSpecs) {
            aggregators[aggregatorIndex] = spec.factorize(cursor);
            ++aggregatorIndex;
        }
        return aggregators;
    }

    public static <T> Sequence<Result<T>> makeCursorBasedQuery(final StorageAdapter adapter, List<Interval> queryIntervals, Filter filter, boolean descending, QueryGranularity granularity, final Function<Cursor, Result<T>> mapFn) {
        Preconditions.checkArgument(queryIntervals.size() == 1, "Can only handle a single interval, got[%s]", queryIntervals);
        return Sequences.filter(Sequences.map(adapter.makeCursors(filter, queryIntervals.get(0), granularity, descending), new Function<Cursor, Result<T>>(){

            @Override
            public Result<T> apply(Cursor input) {
                log.debug("Running over cursor[%s]", adapter.getInterval(), input.getTime());
                return (Result)mapFn.apply(input);
            }
        }), Predicates.notNull());
    }

    public static <T> QueryRunner<T> makeClosingQueryRunner(final QueryRunner<T> runner, final Closeable closeable) {
        return new QueryRunner<T>(){

            @Override
            public Sequence<T> run(Query<T> query, Map<String, Object> responseContext) {
                return new ResourceClosingSequence(runner.run(query, responseContext), closeable);
            }
        };
    }
}

