/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.com.metamx.common.guava.Yielder;
import org.apache.hive.druid.com.metamx.common.guava.YieldingAccumulator;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.io.druid.common.utils.VMUtils;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;

public class CPUTimeMetricQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> delegate;
    private final Function<Query<T>, ServiceMetricEvent.Builder> builderFn;
    private final ServiceEmitter emitter;
    private final AtomicLong cpuTimeAccumulator;
    private final boolean report;

    private CPUTimeMetricQueryRunner(QueryRunner<T> delegate, Function<Query<T>, ServiceMetricEvent.Builder> builderFn, ServiceEmitter emitter, AtomicLong cpuTimeAccumulator, boolean report) {
        if (!VMUtils.isThreadCpuTimeEnabled()) {
            throw new ISE("Cpu time must enabled", new Object[0]);
        }
        this.delegate = delegate;
        this.builderFn = builderFn;
        this.emitter = emitter;
        this.cpuTimeAccumulator = cpuTimeAccumulator == null ? new AtomicLong(0L) : cpuTimeAccumulator;
        this.report = report;
    }

    @Override
    public Sequence<T> run(final Query<T> query, Map<String, Object> responseContext) {
        final Sequence<T> baseSequence = this.delegate.run(query, responseContext);
        return Sequences.withEffect(new Sequence<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                long start = VMUtils.getCurrentThreadCpuTime();
                try {
                    OutType OutType = baseSequence.accumulate(initValue, accumulator);
                    return OutType;
                }
                finally {
                    CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.addAndGet(VMUtils.getCurrentThreadCpuTime() - start);
                }
            }

            @Override
            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                final Yielder<OutType> delegateYielder = baseSequence.toYielder(initValue, accumulator);
                return new Yielder<OutType>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public OutType get() {
                        long start = VMUtils.getCurrentThreadCpuTime();
                        try {
                            Object t = delegateYielder.get();
                            return t;
                        }
                        finally {
                            CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.addAndGet(VMUtils.getCurrentThreadCpuTime() - start);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Yielder<OutType> next(OutType initValue) {
                        long start = VMUtils.getCurrentThreadCpuTime();
                        try {
                            Yielder yielder = delegateYielder.next(initValue);
                            return yielder;
                        }
                        finally {
                            CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.addAndGet(VMUtils.getCurrentThreadCpuTime() - start);
                        }
                    }

                    @Override
                    public boolean isDone() {
                        return delegateYielder.isDone();
                    }

                    @Override
                    public void close() throws IOException {
                        delegateYielder.close();
                    }
                };
            }
        }, new Runnable(){

            @Override
            public void run() {
                long cpuTime;
                if (CPUTimeMetricQueryRunner.this.report && (cpuTime = CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.get()) > 0L) {
                    ServiceMetricEvent.Builder builder = (ServiceMetricEvent.Builder)Preconditions.checkNotNull(CPUTimeMetricQueryRunner.this.builderFn.apply(query));
                    CPUTimeMetricQueryRunner.this.emitter.emit(builder.build("query/cpu/time", CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.get() / 1000L));
                }
            }
        }, MoreExecutors.sameThreadExecutor());
    }

    public static <T> QueryRunner<T> safeBuild(QueryRunner<T> delegate, Function<Query<T>, ServiceMetricEvent.Builder> builderFn, ServiceEmitter emitter, AtomicLong accumulator, boolean report) {
        if (!VMUtils.isThreadCpuTimeEnabled()) {
            return delegate;
        }
        return new CPUTimeMetricQueryRunner<T>(delegate, builderFn, emitter, accumulator, report);
    }
}

