/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.math.expr;

import java.util.Map;
import org.apache.hive.druid.io.druid.math.expr.BinaryOpExprBase;
import org.apache.hive.druid.io.druid.math.expr.Expr;

class BinOrExpr
extends BinaryOpExprBase {
    BinOrExpr(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    public Number eval(Map<String, Number> bindings) {
        Number rightVal;
        Number leftVal = this.left.eval(bindings);
        if (this.isLong(leftVal, rightVal = this.right.eval(bindings))) {
            long lval = leftVal.longValue();
            if (lval > 0L) {
                return 1;
            }
            long rval = rightVal.longValue();
            return rval > 0L ? 1 : 0;
        }
        double lval = leftVal.doubleValue();
        if (lval > 0.0) {
            return 1.0;
        }
        double rval = rightVal.doubleValue();
        return rval > 0.0 ? 1.0 : 0.0;
    }
}

