/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice.http;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import javax.net.ssl.SSLContext;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.annotations.Global;
import org.apache.hive.druid.io.druid.guice.http.AbstractHttpClientProvider;
import org.apache.hive.druid.io.druid.guice.http.DruidHttpClientConfig;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyHttpClientModule
implements Module {
    private final String propertyPrefix;
    private Annotation annotation = null;
    private Class<? extends Annotation> annotationClazz = null;

    public static JettyHttpClientModule global() {
        return new JettyHttpClientModule("druid.global.http", Global.class);
    }

    public JettyHttpClientModule(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    public JettyHttpClientModule(String propertyPrefix, Class<? extends Annotation> annotation) {
        this.propertyPrefix = propertyPrefix;
        this.annotationClazz = annotation;
    }

    public JettyHttpClientModule(String propertyPrefix, Annotation annotation) {
        this.propertyPrefix = propertyPrefix;
        this.annotation = annotation;
    }

    public void configure(Binder binder) {
        if (this.annotation != null) {
            JsonConfigProvider.bind(binder, this.propertyPrefix, DruidHttpClientConfig.class, this.annotation);
            binder.bind(HttpClient.class).annotatedWith(this.annotation).toProvider((Provider)new HttpClientProvider(this.annotation)).in(LazySingleton.class);
        } else if (this.annotationClazz != null) {
            JsonConfigProvider.bind(binder, this.propertyPrefix, DruidHttpClientConfig.class, this.annotationClazz);
            binder.bind(HttpClient.class).annotatedWith(this.annotationClazz).toProvider((Provider)new HttpClientProvider(this.annotationClazz)).in(LazySingleton.class);
        } else {
            JsonConfigProvider.bind(binder, this.propertyPrefix, DruidHttpClientConfig.class);
            binder.bind(HttpClient.class).toProvider((Provider)new HttpClientProvider()).in(LazySingleton.class);
        }
    }

    public static class HttpClientProvider
    extends AbstractHttpClientProvider<HttpClient> {
        public HttpClientProvider() {
        }

        public HttpClientProvider(Annotation annotation) {
            super(annotation);
        }

        public HttpClientProvider(Class<? extends Annotation> annotation) {
            super(annotation);
        }

        public HttpClient get() {
            HttpClient httpClient;
            DruidHttpClientConfig config = (DruidHttpClientConfig)((Supplier)this.getConfigProvider().get()).get();
            if (this.getSslContextBinding() != null) {
                SslContextFactory sslContextFactory = new SslContextFactory();
                sslContextFactory.setSslContext((SSLContext)this.getSslContextBinding().getProvider().get());
                httpClient = new HttpClient(sslContextFactory);
            } else {
                httpClient = new HttpClient();
            }
            httpClient.setIdleTimeout(config.getReadTimeout().getMillis());
            httpClient.setMaxConnectionsPerDestination(config.getNumConnections());
            Lifecycle lifecycle = (Lifecycle)this.getLifecycleProvider().get();
            try {
                lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                    @Override
                    public void start() throws Exception {
                    }

                    @Override
                    public void stop() {
                        try {
                            httpClient.stop();
                        }
                        catch (Exception e) {
                            throw Throwables.propagate(e);
                        }
                    }
                });
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
            return httpClient;
        }
    }
}

