/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input.impl;

import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.metamx.common.parsers.DelimitedParser;
import org.apache.hive.druid.com.metamx.common.parsers.Parser;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;

public class DelimitedParseSpec
extends ParseSpec {
    private final String delimiter;
    private final String listDelimiter;
    private final List<String> columns;

    @JsonCreator
    public DelimitedParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="listDelimiter") String listDelimiter, @JsonProperty(value="columns") List<String> columns) {
        super(timestampSpec, dimensionsSpec);
        this.delimiter = delimiter;
        this.listDelimiter = listDelimiter;
        Preconditions.checkNotNull(columns, "columns");
        this.columns = columns;
        for (String column : this.columns) {
            Preconditions.checkArgument(!column.contains(","), "Column[%s] has a comma, it cannot", column);
        }
        this.verify(dimensionsSpec.getDimensionNames());
    }

    @JsonProperty(value="delimiter")
    public String getDelimiter() {
        return this.delimiter;
    }

    @JsonProperty(value="listDelimiter")
    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @JsonProperty(value="columns")
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public void verify(List<String> usedCols) {
        for (String columnName : usedCols) {
            Preconditions.checkArgument(this.columns.contains(columnName), "column[%s] not in columns.", columnName);
        }
    }

    @Override
    public Parser<String, Object> makeParser() {
        DelimitedParser retVal = new DelimitedParser(Optional.fromNullable(this.delimiter), Optional.fromNullable(this.listDelimiter));
        retVal.setFieldNames(this.columns);
        return retVal;
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new DelimitedParseSpec(spec, this.getDimensionsSpec(), this.delimiter, this.listDelimiter, this.columns);
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new DelimitedParseSpec(this.getTimestampSpec(), spec, this.delimiter, this.listDelimiter, this.columns);
    }

    public ParseSpec withDelimiter(String delim) {
        return new DelimitedParseSpec(this.getTimestampSpec(), this.getDimensionsSpec(), delim, this.listDelimiter, this.columns);
    }

    public ParseSpec withListDelimiter(String delim) {
        return new DelimitedParseSpec(this.getTimestampSpec(), this.getDimensionsSpec(), this.delimiter, delim, this.columns);
    }

    public ParseSpec withColumns(List<String> cols) {
        return new DelimitedParseSpec(this.getTimestampSpec(), this.getDimensionsSpec(), this.delimiter, this.listDelimiter, cols);
    }
}

