/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.common.guava;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.io.CharStreams;
import org.apache.hive.druid.com.google.common.io.InputSupplier;

public class GuavaUtils {
    public static Function<String, String> formatFunction(final String formatString) {
        return new Function<String, String>(){

            @Override
            public String apply(@Nullable String input) {
                return String.format(formatString, input);
            }
        };
    }

    public static InputSupplier<BufferedReader> joinFiles(File ... files) {
        return GuavaUtils.joinFiles(Arrays.asList(files));
    }

    public static InputSupplier<BufferedReader> joinFiles(final List<File> files) {
        return new InputSupplier<BufferedReader>(){

            @Override
            public BufferedReader getInput() throws IOException {
                return new BufferedReader(CharStreams.join(Iterables.transform(files, new Function<File, InputSupplier<InputStreamReader>>(){

                    @Override
                    public InputSupplier<InputStreamReader> apply(final File input) {
                        return new InputSupplier<InputStreamReader>(){

                            @Override
                            public InputStreamReader getInput() throws IOException {
                                InputStream baseStream = new FileInputStream(input);
                                if (input.getName().endsWith(".gz")) {
                                    baseStream = new GZIPInputStream(baseStream);
                                }
                                return new InputStreamReader(baseStream, Charsets.UTF_8);
                            }
                        };
                    }
                })).getInput());
            }
        };
    }
}

