/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.PeekingIterator;
import org.apache.hive.druid.com.metamx.common.guava.FunctionalIterator;

public class OrderedMergeIterator<T>
implements Iterator<T> {
    private final PriorityQueue<PeekingIterator<T>> firstElementComparedPQueue;
    private PeekingIterator<PeekingIterator<T>> iterOfIterators;
    private final Comparator<T> comparator;

    public OrderedMergeIterator(final Comparator<T> comparator, Iterator<Iterator<T>> iterators) {
        this.comparator = comparator;
        this.firstElementComparedPQueue = new PriorityQueue(16, new Comparator<PeekingIterator<T>>(){

            @Override
            public int compare(PeekingIterator<T> lhs, PeekingIterator<T> rhs) {
                return comparator.compare(lhs.peek(), rhs.peek());
            }
        });
        this.iterOfIterators = Iterators.peekingIterator(FunctionalIterator.create(iterators).filter(new Predicate<Iterator<T>>(){

            @Override
            public boolean apply(Iterator<T> input) {
                return input.hasNext();
            }
        }).transform(new Function<Iterator<T>, PeekingIterator<T>>(){

            @Override
            public PeekingIterator<T> apply(Iterator<T> input) {
                return Iterators.peekingIterator(input);
            }
        }));
    }

    @Override
    public boolean hasNext() {
        return !this.firstElementComparedPQueue.isEmpty() || this.iterOfIterators.hasNext();
    }

    @Override
    public T next() {
        T iterItersValue;
        T pQueueValue;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        PeekingIterator<T> littleIt = !this.iterOfIterators.hasNext() ? (PeekingIterator<T>)this.firstElementComparedPQueue.remove() : (this.firstElementComparedPQueue.isEmpty() ? this.iterOfIterators.next() : (this.comparator.compare(pQueueValue = this.firstElementComparedPQueue.peek().peek(), iterItersValue = this.iterOfIterators.peek().peek()) <= 0 ? (PeekingIterator<T>)this.firstElementComparedPQueue.remove() : this.iterOfIterators.next()));
        Object retVal = littleIt.next();
        if (littleIt.hasNext()) {
            this.firstElementComparedPQueue.add(littleIt);
        }
        return (T)retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

