/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.http.client.response;

import java.nio.charset.Charset;
import org.apache.hive.druid.com.metamx.http.client.response.ClientResponse;
import org.apache.hive.druid.com.metamx.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpChunk;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponse;

public class ToStringResponseHandler
implements HttpResponseHandler<StringBuilder, String> {
    private final Charset charset;

    public ToStringResponseHandler(Charset charset) {
        this.charset = charset;
    }

    @Override
    public ClientResponse<StringBuilder> handleResponse(HttpResponse response) {
        return ClientResponse.unfinished(new StringBuilder(response.getContent().toString(this.charset)));
    }

    @Override
    public ClientResponse<StringBuilder> handleChunk(ClientResponse<StringBuilder> response, HttpChunk chunk) {
        StringBuilder builder = response.getObj();
        if (builder == null) {
            return ClientResponse.finished(null);
        }
        builder.append(chunk.getContent().toString(this.charset));
        return response;
    }

    @Override
    public ClientResponse<String> done(ClientResponse<StringBuilder> response) {
        StringBuilder builder = response.getObj();
        if (builder == null) {
            return ClientResponse.finished(null);
        }
        return ClientResponse.finished(builder.toString());
    }

    @Override
    public void exceptionCaught(ClientResponse<StringBuilder> clientResponse, Throwable e) {
    }
}

