/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.collections.spatial.search;

import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.com.metamx.collections.spatial.ImmutableNode;
import org.apache.hive.druid.com.metamx.collections.spatial.ImmutablePoint;
import org.apache.hive.druid.com.metamx.collections.spatial.search.Bound;
import org.apache.hive.druid.com.metamx.collections.spatial.search.SearchStrategy;

public class GutmanSearchStrategy
implements SearchStrategy {
    @Override
    public Iterable<ImmutableBitmap> search(ImmutableNode node, Bound bound) {
        if (bound.getLimit() > 0) {
            return Iterables.transform(this.breadthFirstSearch(node, bound), new Function<ImmutableNode, ImmutableBitmap>(){

                @Override
                public ImmutableBitmap apply(ImmutableNode immutableNode) {
                    return immutableNode.getImmutableBitmap();
                }
            });
        }
        return Iterables.transform(this.depthFirstSearch(node, bound), new Function<ImmutablePoint, ImmutableBitmap>(){

            @Override
            public ImmutableBitmap apply(ImmutablePoint immutablePoint) {
                return immutablePoint.getImmutableBitmap();
            }
        });
    }

    public Iterable<ImmutablePoint> depthFirstSearch(ImmutableNode node, final Bound bound) {
        if (node.isLeaf()) {
            return bound.filter(Iterables.transform(node.getChildren(), new Function<ImmutableNode, ImmutablePoint>(){

                @Override
                public ImmutablePoint apply(ImmutableNode tNode) {
                    return new ImmutablePoint(tNode);
                }
            }));
        }
        return Iterables.concat(Iterables.transform(Iterables.filter(node.getChildren(), new Predicate<ImmutableNode>(){

            @Override
            public boolean apply(ImmutableNode child) {
                return bound.overlaps(child);
            }
        }), new Function<ImmutableNode, Iterable<ImmutablePoint>>(){

            @Override
            public Iterable<ImmutablePoint> apply(ImmutableNode child) {
                return GutmanSearchStrategy.this.depthFirstSearch(child, bound);
            }
        }));
    }

    public Iterable<ImmutableNode> breadthFirstSearch(ImmutableNode node, final Bound bound) {
        if (node.isLeaf()) {
            return Iterables.filter(node.getChildren(), new Predicate<ImmutableNode>(){

                @Override
                public boolean apply(ImmutableNode immutableNode) {
                    return bound.contains(immutableNode.getMinCoordinates());
                }
            });
        }
        return this.breadthFirstSearch(node.getChildren(), bound, 0);
    }

    public Iterable<ImmutableNode> breadthFirstSearch(Iterable<ImmutableNode> nodes, final Bound bound, int total) {
        Iterable<ImmutableNode> points = Iterables.concat(Iterables.transform(Iterables.filter(nodes, new Predicate<ImmutableNode>(){

            @Override
            public boolean apply(ImmutableNode immutableNode) {
                return immutableNode.isLeaf();
            }
        }), new Function<ImmutableNode, Iterable<ImmutableNode>>(){

            @Override
            public Iterable<ImmutableNode> apply(ImmutableNode immutableNode) {
                return Iterables.filter(immutableNode.getChildren(), new Predicate<ImmutableNode>(){

                    @Override
                    public boolean apply(ImmutableNode immutableNode) {
                        return bound.contains(immutableNode.getMinCoordinates());
                    }
                });
            }
        }));
        Iterable<ImmutableNode> overlappingNodes = Iterables.filter(nodes, new Predicate<ImmutableNode>(){

            @Override
            public boolean apply(ImmutableNode immutableNode) {
                return !immutableNode.isLeaf() && bound.overlaps(immutableNode);
            }
        });
        int totalPoints = Iterables.size(points);
        int totalOverlap = Iterables.size(overlappingNodes);
        if (totalOverlap == 0 || totalPoints + totalOverlap + total >= bound.getLimit()) {
            return Iterables.concat(points, overlappingNodes);
        }
        return Iterables.concat(points, this.breadthFirstSearch(Iterables.concat(Iterables.transform(overlappingNodes, new Function<ImmutableNode, Iterable<ImmutableNode>>(){

            @Override
            public Iterable<ImmutableNode> apply(ImmutableNode immutableNode) {
                return immutableNode.getChildren();
            }
        })), bound, totalPoints));
    }
}

