/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.io.HiveDruidSplit;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.HttpClientConfig;
import org.apache.hive.druid.com.metamx.http.client.HttpClientInit;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DruidQueryRecordReader<T extends BaseQuery<R>, R extends Comparable<R>>
extends RecordReader<NullWritable, DruidWritable>
implements org.apache.hadoop.mapred.RecordReader<NullWritable, DruidWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(DruidQueryRecordReader.class);
    protected T query;
    protected Iterator<R> results = Iterators.emptyIterator();

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        this.initialize(split, context.getConfiguration());
    }

    public void initialize(InputSplit split, Configuration conf) throws IOException {
        List<R> resultsList;
        InputStream response;
        HiveDruidSplit hiveDruidSplit = (HiveDruidSplit)split;
        this.query = this.createQuery(hiveDruidSplit.getDruidQuery());
        if (LOG.isInfoEnabled()) {
            LOG.info("Retrieving from druid using query:\n " + this.query);
        }
        Lifecycle lifecycle = new Lifecycle();
        int numConnection = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_NUM_HTTP_CONNECTION);
        Period readTimeout = new Period((Object)HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_HTTP_READ_TIMEOUT));
        HttpClient client = HttpClientInit.createClient(HttpClientConfig.builder().withReadTimeout(readTimeout.toStandardDuration()).withNumConnections(numConnection).build(), lifecycle);
        try {
            lifecycle.start();
        }
        catch (Exception e) {
            LOG.error("Issues with lifecycle start", (Throwable)e);
        }
        try {
            response = DruidStorageHandlerUtils.submitRequest(client, DruidStorageHandlerUtils.createRequest(hiveDruidSplit.getLocations()[0], this.query));
        }
        catch (Exception e) {
            lifecycle.stop();
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        try {
            resultsList = this.createResultsList(response);
        }
        catch (IOException e) {
            response.close();
            throw e;
        }
        finally {
            lifecycle.stop();
        }
        if (resultsList == null || resultsList.isEmpty()) {
            return;
        }
        this.results = resultsList.iterator();
    }

    protected abstract T createQuery(String var1) throws IOException;

    protected abstract List<R> createResultsList(InputStream var1) throws IOException;

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public DruidWritable createValue() {
        return new DruidWritable();
    }

    public abstract boolean next(NullWritable var1, DruidWritable var2) throws IOException;

    public long getPos() {
        return 0L;
    }

    public abstract boolean nextKeyValue() throws IOException;

    public abstract NullWritable getCurrentKey() throws IOException, InterruptedException;

    public abstract DruidWritable getCurrentValue() throws IOException, InterruptedException;

    public abstract float getProgress() throws IOException;

    public void close() {
    }
}

