/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;

public class DruidGroupByQueryRecordReader
extends DruidQueryRecordReader<GroupByQuery, Row> {
    private Row current;
    private int[] indexes = new int[0];
    private Extract[] extractors;

    @Override
    public void initialize(InputSplit split, Configuration conf) throws IOException {
        super.initialize(split, conf);
        this.initExtractors();
    }

    @Override
    protected GroupByQuery createQuery(String content) throws IOException {
        return DruidStorageHandlerUtils.JSON_MAPPER.readValue(content, GroupByQuery.class);
    }

    @Override
    protected List<Row> createResultsList(InputStream content) throws IOException {
        return DruidStorageHandlerUtils.SMILE_MAPPER.readValue(content, new TypeReference<List<Row>>(){});
    }

    private void initExtractors() throws IOException {
        this.extractors = new Extract[((GroupByQuery)this.query).getAggregatorSpecs().size() + ((GroupByQuery)this.query).getPostAggregatorSpecs().size()];
        int counter = 0;
        int i = 0;
        while (i < ((GroupByQuery)this.query).getAggregatorSpecs().size()) {
            AggregatorFactory af = ((GroupByQuery)this.query).getAggregatorSpecs().get(i);
            switch (af.getTypeName().toUpperCase()) {
                case "FLOAT": {
                    this.extractors[counter] = Extract.FLOAT;
                    break;
                }
                case "LONG": {
                    this.extractors[counter] = Extract.LONG;
                    break;
                }
                default: {
                    throw new IOException("Type not supported");
                }
            }
            ++i;
            ++counter;
        }
        i = 0;
        while (i < ((GroupByQuery)this.query).getPostAggregatorSpecs().size()) {
            this.extractors[counter] = Extract.FLOAT;
            ++i;
            ++counter;
        }
    }

    @Override
    public boolean nextKeyValue() {
        int i;
        for (i = this.indexes.length - 1; i >= 0; --i) {
            if (this.indexes[i] <= 0) continue;
            int n = i;
            this.indexes[n] = this.indexes[n] - 1;
            for (int j = i + 1; j < this.indexes.length; ++j) {
                this.indexes[j] = this.current.getDimension(((GroupByQuery)this.query).getDimensions().get(j).getDimension()).size() - 1;
            }
            return true;
        }
        if (this.results.hasNext()) {
            this.current = (Row)this.results.next();
            this.indexes = new int[((GroupByQuery)this.query).getDimensions().size()];
            for (i = 0; i < ((GroupByQuery)this.query).getDimensions().size(); ++i) {
                DimensionSpec ds = ((GroupByQuery)this.query).getDimensions().get(i);
                this.indexes[i] = this.current.getDimension(ds.getDimension()).size() - 1;
            }
            return true;
        }
        return false;
    }

    @Override
    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    @Override
    public DruidWritable getCurrentValue() throws IOException, InterruptedException {
        DruidWritable value = new DruidWritable();
        value.getValue().put("__time", this.current.getTimestamp().getMillis());
        for (int i = 0; i < ((GroupByQuery)this.query).getDimensions().size(); ++i) {
            DimensionSpec ds = ((GroupByQuery)this.query).getDimensions().get(i);
            List<String> dims = this.current.getDimension(ds.getDimension());
            if (dims.size() == 0) {
                value.getValue().put(ds.getOutputName(), null);
                continue;
            }
            int pos = dims.size() - this.indexes[i] - 1;
            value.getValue().put(ds.getOutputName(), dims.get(pos));
        }
        int counter = 0;
        for (AggregatorFactory af : ((GroupByQuery)this.query).getAggregatorSpecs()) {
            switch (this.extractors[counter++]) {
                case FLOAT: {
                    value.getValue().put(af.getName(), Float.valueOf(this.current.getFloatMetric(af.getName())));
                    break;
                }
                case LONG: {
                    value.getValue().put(af.getName(), this.current.getLongMetric(af.getName()));
                }
            }
        }
        for (PostAggregator pa : ((GroupByQuery)this.query).getPostAggregatorSpecs()) {
            assert (this.extractors[counter++] == Extract.FLOAT);
            value.getValue().put(pa.getName(), Float.valueOf(this.current.getFloatMetric(pa.getName())));
        }
        return value;
    }

    @Override
    public boolean next(NullWritable key, DruidWritable value) {
        if (this.nextKeyValue()) {
            value.getValue().clear();
            value.getValue().put("__time", this.current.getTimestamp().getMillis());
            for (int i = 0; i < ((GroupByQuery)this.query).getDimensions().size(); ++i) {
                DimensionSpec ds = ((GroupByQuery)this.query).getDimensions().get(i);
                List<String> dims = this.current.getDimension(ds.getDimension());
                if (dims.size() == 0) {
                    value.getValue().put(ds.getOutputName(), null);
                    continue;
                }
                int pos = dims.size() - this.indexes[i] - 1;
                value.getValue().put(ds.getOutputName(), dims.get(pos));
            }
            int counter = 0;
            for (AggregatorFactory af : ((GroupByQuery)this.query).getAggregatorSpecs()) {
                switch (this.extractors[counter++]) {
                    case FLOAT: {
                        value.getValue().put(af.getName(), Float.valueOf(this.current.getFloatMetric(af.getName())));
                        break;
                    }
                    case LONG: {
                        value.getValue().put(af.getName(), this.current.getLongMetric(af.getName()));
                    }
                }
            }
            for (PostAggregator pa : ((GroupByQuery)this.query).getPostAggregatorSpecs()) {
                assert (this.extractors[counter++] == Extract.FLOAT);
                value.getValue().put(pa.getName(), Float.valueOf(this.current.getFloatMetric(pa.getName())));
            }
            return true;
        }
        return false;
    }

    @Override
    public float getProgress() throws IOException {
        return this.results.hasNext() ? 0.0f : 1.0f;
    }

    private static enum Extract {
        FLOAT,
        LONG;

    }
}

