/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.druid.DruidStorageHandler;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.hive.druid.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableCollection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Interner;
import org.apache.hive.druid.com.google.common.collect.Interners;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.io.CharStreams;
import org.apache.hive.druid.com.metamx.common.MapUtils;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.com.metamx.emitter.core.NoopEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.Request;
import org.apache.hive.druid.com.metamx.http.client.response.InputStreamResponseHandler;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.metadata.storage.mysql.MySQLConnector;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMergerV9;
import org.apache.hive.druid.io.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.LinearShardSpec;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.util.ByteArrayMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DruidStorageHandlerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DruidStorageHandlerUtils.class);
    private static final String SMILE_CONTENT_TYPE = "application/x-jackson-smile";
    public static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    public static final ObjectMapper SMILE_MAPPER = new DefaultObjectMapper(new SmileFactory());
    private static final int NUM_RETRIES = 8;
    private static final int SECONDS_BETWEEN_RETRIES = 2;
    private static final int DEFAULT_FS_BUFFER_SIZE = 262144;
    private static final int DEFAULT_STREAMING_RESULT_SIZE = 100;
    public static final IndexIO INDEX_IO = new IndexIO(JSON_MAPPER, new ColumnConfig(){

        @Override
        public int columnCacheSizeBytes() {
            return 0;
        }
    });
    public static final IndexMergerV9 INDEX_MERGER_V9 = new IndexMergerV9(JSON_MAPPER, INDEX_IO);
    public static final Interner<DataSegment> DATA_SEGMENT_INTERNER = Interners.newWeakInterner();

    public static Request createRequest(String address, BaseQuery<?> query) throws IOException {
        return new Request(HttpMethod.POST, new URL(String.format("%s/druid/v2/", "http://" + address))).setContent(SMILE_MAPPER.writeValueAsBytes(query)).setHeader("Content-Type", SMILE_CONTENT_TYPE);
    }

    public static InputStream submitRequest(HttpClient client, Request request) throws IOException {
        InputStream response;
        try {
            response = (InputStream)client.go(request, new InputStreamResponseHandler()).get();
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new IOException(e.getCause());
        }
        return response;
    }

    public static String getURL(HttpClient client, URL url) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(DruidStorageHandlerUtils.submitRequest(client, new Request(HttpMethod.GET, url)));){
            String string = CharStreams.toString(reader);
            return string;
        }
    }

    public static List<DataSegment> getPublishedSegments(Path taskDir, Configuration conf) throws IOException {
        ImmutableList.Builder publishedSegmentsBuilder = ImmutableList.builder();
        FileSystem fs = taskDir.getFileSystem(conf);
        for (FileStatus fileStatus : fs.listStatus(taskDir)) {
            DataSegment segment = JSON_MAPPER.readValue((InputStream)fs.open(fileStatus.getPath()), DataSegment.class);
            publishedSegmentsBuilder.add(segment);
        }
        ImmutableCollection publishedSegments = publishedSegmentsBuilder.build();
        return publishedSegments;
    }

    public static void writeSegmentDescriptor(final FileSystem outputFS, final DataSegment segment, final Path descriptorPath) throws IOException {
        DataPusher descriptorPusher = (DataPusher)RetryProxy.create(DataPusher.class, (Object)new DataPusher(){

            @Override
            public long push() throws IOException {
                if (outputFS.exists(descriptorPath) && !outputFS.delete(descriptorPath, false)) {
                    throw new IOException(String.format("Failed to delete descriptor at [%s]", descriptorPath));
                }
                try (FSDataOutputStream descriptorOut = outputFS.create(descriptorPath, true, 262144);){
                    JSON_MAPPER.writeValue((OutputStream)descriptorOut, (Object)segment);
                    descriptorOut.flush();
                }
                return -1L;
            }
        }, (RetryPolicy)RetryPolicies.exponentialBackoffRetry((int)8, (long)2L, (TimeUnit)TimeUnit.SECONDS));
        descriptorPusher.push();
    }

    public static Collection<String> getAllDataSourceNames(SQLMetadataConnector connector, final MetadataStorageTablesConfig metadataStorageTablesConfig) {
        return connector.getDBI().withHandle(new HandleCallback<List<String>>(){

            @Override
            public List<String> withHandle(Handle handle) throws Exception {
                return handle.createQuery(String.format("SELECT DISTINCT(datasource) FROM %s WHERE used = true", metadataStorageTablesConfig.getSegmentsTable())).fold(Lists.newArrayList(), new Folder3<ArrayList<String>, Map<String, Object>>(){

                    @Override
                    public ArrayList<String> fold(ArrayList<String> druidDataSources, Map<String, Object> stringObjectMap, FoldController foldController, StatementContext statementContext) throws SQLException {
                        druidDataSources.add(MapUtils.getString(stringObjectMap, "datasource"));
                        return druidDataSources;
                    }
                });
            }
        });
    }

    public static boolean disableDataSource(SQLMetadataConnector connector, final MetadataStorageTablesConfig metadataStorageTablesConfig, final String dataSource) {
        try {
            if (!DruidStorageHandlerUtils.getAllDataSourceNames(connector, metadataStorageTablesConfig).contains(dataSource)) {
                DruidStorageHandler.LOG.warn(String.format("Cannot delete data source [%s], does not exist", dataSource));
                return false;
            }
            connector.getDBI().withHandle(new HandleCallback<Void>(){

                @Override
                public Void withHandle(Handle handle) throws Exception {
                    ((Update)handle.createStatement(String.format("UPDATE %s SET used=false WHERE dataSource = :dataSource", metadataStorageTablesConfig.getSegmentsTable())).bind("dataSource", dataSource)).execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            DruidStorageHandler.LOG.error(String.format("Error removing dataSource %s", dataSource), (Throwable)e);
            return false;
        }
        return true;
    }

    public static List<DataSegment> getDataSegmentList(final SQLMetadataConnector connector, final MetadataStorageTablesConfig metadataStorageTablesConfig, final String dataSource) {
        List<DataSegment> segmentList = connector.retryTransaction(new TransactionCallback<List<DataSegment>>(){

            @Override
            public List<DataSegment> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                return ((Query)handle.createQuery(String.format("SELECT payload FROM %s WHERE dataSource = :dataSource", metadataStorageTablesConfig.getSegmentsTable())).setFetchSize(DruidStorageHandlerUtils.getStreamingFetchSize(connector)).bind("dataSource", dataSource)).map(ByteArrayMapper.FIRST).fold(new ArrayList(), new Folder3<List<DataSegment>, byte[]>(){

                    @Override
                    public List<DataSegment> fold(List<DataSegment> accumulator, byte[] payload, FoldController control, StatementContext ctx) throws SQLException {
                        try {
                            DataSegment segment = DATA_SEGMENT_INTERNER.intern(JSON_MAPPER.readValue(payload, DataSegment.class));
                            accumulator.add(segment);
                            return accumulator;
                        }
                        catch (Exception e) {
                            throw new SQLException(e.toString());
                        }
                    }
                });
            }
        }, 3, 10);
        return segmentList;
    }

    private static int getStreamingFetchSize(SQLMetadataConnector connector) {
        if (connector instanceof MySQLConnector) {
            return Integer.MIN_VALUE;
        }
        return 100;
    }

    public static Path makeSegmentDescriptorOutputPath(DataSegment pushedSegment, Path segmentsDescriptorDir) {
        return new Path(segmentsDescriptorDir, String.format("%s.json", pushedSegment.getIdentifier().replace(":", "")));
    }

    public static void addDependencyJars(Configuration conf, Class<?> ... classes) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> jars = new HashSet<String>();
        jars.addAll(conf.getStringCollection("tmpjars"));
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            String path = Utilities.jarFinderGetJar(clazz);
            if (path == null) {
                throw new RuntimeException("Could not find jar for class " + clazz + " in order to ship it to the cluster.");
            }
            if (!localFs.exists(new Path(path))) {
                throw new RuntimeException("Could not validate jar file " + path + " for class " + clazz);
            }
            jars.add(path.toString());
        }
        if (jars.isEmpty()) {
            return;
        }
        conf.set("tmpjars", StringUtils.arrayToString((String[])jars.toArray(new String[jars.size()])));
    }

    static {
        JSON_MAPPER.registerSubtypes(new NamedType(LinearShardSpec.class, "linear"));
        JSON_MAPPER.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            EmittingLogger.registerEmitter(new ServiceEmitter("druid-hive-indexer", InetAddress.getLocalHost().getHostName(), new NoopEmitter()));
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate(e);
        }
    }

    public static interface DataPusher {
        public long push() throws IOException;
    }
}

