/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.tweak.ContainerFactory;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RegisterContainerMapper {
    public Class<? extends ContainerFactory>[] value();

    public static class MyCustomizer
    implements SqlStatementCustomizer {
        private final List<ContainerFactory> factory;

        MyCustomizer(RegisterContainerMapper annotation) {
            ArrayList<ContainerFactory> ls = new ArrayList<ContainerFactory>();
            try {
                for (Class<? extends ContainerFactory> type : annotation.value()) {
                    ls.add(type.newInstance());
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to instantiate container factory", e);
            }
            this.factory = ls;
        }

        @Override
        public void apply(SQLStatement q) throws SQLException {
            if (q instanceof Query) {
                Query query = (Query)q;
                for (ContainerFactory containerFactory : this.factory) {
                    query.registerContainerFactory(containerFactory);
                }
            }
        }
    }

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            return new MyCustomizer((RegisterContainerMapper)annotation);
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            return new MyCustomizer((RegisterContainerMapper)annotation);
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            throw new UnsupportedOperationException("Not Yet Implemented!");
        }
    }
}

