/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.plan;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptQuery;
import org.apache.hive.druid.org.apache.calcite.plan.RelTrait;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.CorrelationId;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.MetadataFactory;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.MetadataFactoryImpl;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;

public class RelOptCluster {
    private final RelDataTypeFactory typeFactory;
    private final RelOptPlanner planner;
    private final AtomicInteger nextCorrel;
    private final Map<String, RelNode> mapCorrelToRel;
    private RexNode originalExpression;
    private final RexBuilder rexBuilder;
    private RelMetadataProvider metadataProvider;
    private MetadataFactory metadataFactory;
    private final RelTraitSet emptyTraitSet;

    @Deprecated
    RelOptCluster(RelOptQuery query, RelOptPlanner planner, RelDataTypeFactory typeFactory, RexBuilder rexBuilder) {
        this(planner, typeFactory, rexBuilder, query.nextCorrel, query.mapCorrelToRel);
    }

    RelOptCluster(RelOptPlanner planner, RelDataTypeFactory typeFactory, RexBuilder rexBuilder, AtomicInteger nextCorrel, Map<String, RelNode> mapCorrelToRel) {
        this.nextCorrel = nextCorrel;
        this.mapCorrelToRel = mapCorrelToRel;
        this.planner = Preconditions.checkNotNull(planner);
        this.typeFactory = Preconditions.checkNotNull(typeFactory);
        this.rexBuilder = rexBuilder;
        this.originalExpression = rexBuilder.makeLiteral("?");
        this.setMetadataProvider(DefaultRelMetadataProvider.INSTANCE);
        this.emptyTraitSet = planner.emptyTraitSet();
        assert (this.emptyTraitSet.size() == planner.getRelTraitDefs().size());
    }

    public static RelOptCluster create(RelOptPlanner planner, RexBuilder rexBuilder) {
        return new RelOptCluster(planner, rexBuilder.getTypeFactory(), rexBuilder, new AtomicInteger(0), new HashMap<String, RelNode>());
    }

    @Deprecated
    public RelOptQuery getQuery() {
        return new RelOptQuery(this.planner, this.nextCorrel, this.mapCorrelToRel);
    }

    @Deprecated
    public RexNode getOriginalExpression() {
        return this.originalExpression;
    }

    @Deprecated
    public void setOriginalExpression(RexNode originalExpression) {
        this.originalExpression = originalExpression;
    }

    public RelOptPlanner getPlanner() {
        return this.planner;
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public RexBuilder getRexBuilder() {
        return this.rexBuilder;
    }

    public RelMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(RelMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
        this.metadataFactory = new MetadataFactoryImpl(metadataProvider);
    }

    public MetadataFactory getMetadataFactory() {
        return this.metadataFactory;
    }

    public CorrelationId createCorrel() {
        return new CorrelationId(this.nextCorrel.getAndIncrement());
    }

    public RelTraitSet traitSet() {
        return this.emptyTraitSet;
    }

    @Deprecated
    public RelTraitSet traitSetOf(RelTrait ... traits) {
        RelTraitSet traitSet = this.emptyTraitSet;
        for (RelTrait trait : traits) {
            traitSet = traitSet.replace(trait);
        }
        return traitSet;
    }

    public RelTraitSet traitSetOf(RelTrait trait) {
        return this.emptyTraitSet.replace(trait);
    }
}

