/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.jdbc;

import java.util.Collection;
import java.util.NavigableSet;
import org.apache.hive.druid.com.google.common.cache.CacheBuilder;
import org.apache.hive.druid.com.google.common.cache.CacheLoader;
import org.apache.hive.druid.com.google.common.cache.LoadingCache;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSortedMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSortedSet;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.hive.druid.org.apache.calcite.schema.Function;
import org.apache.hive.druid.org.apache.calcite.schema.Schema;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.TableMacro;
import org.apache.hive.druid.org.apache.calcite.schema.TranslatableTable;
import org.apache.hive.druid.org.apache.calcite.util.Compatible;

class CachingCalciteSchema
extends CalciteSchema {
    private final Cached<SubSchemaCache> implicitSubSchemaCache = new AbstractCached<SubSchemaCache>(){

        @Override
        public SubSchemaCache build() {
            return new SubSchemaCache(CachingCalciteSchema.this, Compatible.INSTANCE.navigableSet(ImmutableSortedSet.copyOf(CalciteSchema.COMPARATOR, CachingCalciteSchema.this.schema.getSubSchemaNames())));
        }
    };
    private final Cached<NavigableSet<String>> implicitTableCache = new AbstractCached<NavigableSet<String>>(){

        @Override
        public NavigableSet<String> build() {
            return Compatible.INSTANCE.navigableSet(ImmutableSortedSet.copyOf(CalciteSchema.COMPARATOR, CachingCalciteSchema.this.schema.getTableNames()));
        }
    };
    private final Cached<NavigableSet<String>> implicitFunctionCache = new AbstractCached<NavigableSet<String>>(){

        @Override
        public NavigableSet<String> build() {
            return Compatible.INSTANCE.navigableSet(ImmutableSortedSet.copyOf(CalciteSchema.COMPARATOR, CachingCalciteSchema.this.schema.getFunctionNames()));
        }
    };
    private boolean cache = true;

    CachingCalciteSchema(CalciteSchema parent, Schema schema, String name) {
        super(parent, schema, name);
    }

    @Override
    public void setCache(boolean cache) {
        if (cache == this.cache) {
            return;
        }
        long now = System.currentTimeMillis();
        this.implicitSubSchemaCache.enable(now, cache);
        this.implicitTableCache.enable(now, cache);
        this.implicitFunctionCache.enable(now, cache);
        this.cache = cache;
    }

    @Override
    protected boolean isCacheEnabled() {
        return this.cache;
    }

    @Override
    protected CalciteSchema getImplicitSubSchema(String schemaName, boolean caseSensitive) {
        if (caseSensitive) {
            long now = System.currentTimeMillis();
            SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
            if (subSchemaCache.names.contains(schemaName)) {
                return subSchemaCache.cache.getUnchecked(schemaName);
            }
        } else {
            long now = System.currentTimeMillis();
            SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
            String schemaName2 = subSchemaCache.names.floor(schemaName);
            if (schemaName2 != null) {
                return subSchemaCache.cache.getUnchecked(schemaName2);
            }
        }
        return null;
    }

    @Override
    public CalciteSchema add(String name, Schema schema) {
        CachingCalciteSchema calciteSchema = new CachingCalciteSchema(this, schema, name);
        this.subSchemaMap.put(name, calciteSchema);
        return calciteSchema;
    }

    @Override
    protected CalciteSchema.TableEntry getImplicitTable(String tableName, boolean caseSensitive) {
        if (caseSensitive) {
            Table table;
            long now = System.currentTimeMillis();
            if (this.implicitTableCache.get(now).contains(tableName) && (table = this.schema.getTable(tableName)) != null) {
                return this.tableEntry(tableName, table);
            }
        } else {
            Table table;
            long now = System.currentTimeMillis();
            NavigableSet<String> implicitTableNames = this.implicitTableCache.get(now);
            String tableName2 = implicitTableNames.floor(tableName);
            if (tableName2 != null && (table = this.schema.getTable(tableName2)) != null) {
                return this.tableEntry(tableName2, table);
            }
        }
        return null;
    }

    @Override
    protected void addImplicitSubSchemaToBuilder(ImmutableSortedMap.Builder<String, CalciteSchema> builder) {
        ImmutableMap explicitSubSchemas = builder.build();
        long now = System.currentTimeMillis();
        SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
        for (String name : subSchemaCache.names) {
            if (explicitSubSchemas.containsKey(name)) continue;
            builder.put((Object)name, (Object)subSchemaCache.cache.getUnchecked(name));
        }
    }

    @Override
    protected void addImplicitTableToBuilder(ImmutableSortedSet.Builder<String> builder) {
        builder.addAll(this.implicitTableCache.get(System.currentTimeMillis()));
    }

    @Override
    protected void addImplicitFunctionToBuilder(ImmutableList.Builder<Function> builder) {
        for (String name2 : CachingCalciteSchema.find(this.implicitFunctionCache.get(System.currentTimeMillis()), this.name)) {
            Collection<Function> functions = this.schema.getFunctions(name2);
            if (functions == null) continue;
            builder.addAll(functions);
        }
    }

    @Override
    protected void addImplicitFuncNamesToBuilder(ImmutableSortedSet.Builder<String> builder) {
        builder.addAll(this.implicitFunctionCache.get(System.currentTimeMillis()));
    }

    @Override
    protected void addImplicitTablesBasedOnNullaryFunctionsToBuilder(ImmutableSortedMap.Builder<String, Table> builder) {
        ImmutableMap explicitTables = builder.build();
        for (String s : this.implicitFunctionCache.get(System.currentTimeMillis())) {
            if (explicitTables.containsKey(s)) continue;
            for (Function function : this.schema.getFunctions(s)) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply(ImmutableList.of());
                builder.put((Object)s, (Object)table);
            }
        }
    }

    @Override
    protected CalciteSchema.TableEntry getImplicitTableBasedOnNullaryFunction(String tableName, boolean caseSensitive) {
        NavigableSet<String> set = this.implicitFunctionCache.get(System.currentTimeMillis());
        for (String s : CachingCalciteSchema.find(set, tableName)) {
            for (Function function : this.schema.getFunctions(s)) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply(ImmutableList.of());
                return this.tableEntry(tableName, table);
            }
        }
        return null;
    }

    private static class SubSchemaCache {
        final NavigableSet<String> names;
        final LoadingCache<String, CalciteSchema> cache;

        private SubSchemaCache(final CalciteSchema calciteSchema, NavigableSet<String> names) {
            this.names = names;
            this.cache = CacheBuilder.newBuilder().build(new CacheLoader<String, CalciteSchema>(){

                @Override
                public CalciteSchema load(String schemaName) {
                    Schema subSchema = calciteSchema.schema.getSubSchema(schemaName);
                    if (subSchema == null) {
                        throw new RuntimeException("sub-schema " + schemaName + " not found");
                    }
                    return new CachingCalciteSchema(calciteSchema, subSchema, schemaName);
                }
            });
        }
    }

    private abstract class AbstractCached<T>
    implements Cached<T> {
        T t;
        long checked = Long.MIN_VALUE;

        private AbstractCached() {
        }

        @Override
        public T get(long now) {
            if (!CachingCalciteSchema.this.cache) {
                return this.build();
            }
            if (this.checked == Long.MIN_VALUE || CachingCalciteSchema.this.schema.contentsHaveChangedSince(this.checked, now)) {
                this.t = this.build();
            }
            this.checked = now;
            return this.t;
        }

        @Override
        public void enable(long now, boolean enabled) {
            if (!enabled) {
                this.t = null;
            }
            this.checked = Long.MIN_VALUE;
        }
    }

    private static interface Cached<T> {
        public T get(long var1);

        public T build();

        public void enable(long var1, boolean var3);
    }
}

